/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.processor.storage;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import org.openas2.OpenAS2Exception;
import org.openas2.WrappedException;
import org.openas2.message.Message;
import org.openas2.message.MessageMDN;
import org.openas2.params.CompositeParameters;
import org.openas2.params.DateParameters;
import org.openas2.params.InvalidParameterException;
import org.openas2.params.MessageMDNParameters;
import org.openas2.params.ParameterParser;
import org.openas2.params.RandomParameters;
import org.openas2.processor.storage.BaseStorageModule;

public class MDNFileModule
extends BaseStorageModule {
    @Override
    public void handle(String action, Message msg, Map<Object, Object> options) throws OpenAS2Exception {
        if (msg.getMDN() == null) {
            throw new OpenAS2Exception("Message has no MDN");
        }
        try {
            File mdnFile = this.getFile(msg, this.getParameter("filename", true), "");
            InputStream in = this.getMDNStream(msg.getMDN());
            this.store(mdnFile, in);
        }
        catch (IOException ioe) {
            throw new WrappedException(ioe);
        }
    }

    @Override
    protected String getModuleAction() {
        return "storemdn";
    }

    @Override
    protected String getFilename(Message msg, String fileParam, String action) throws InvalidParameterException {
        MessageMDN mdn = msg.getMDN();
        CompositeParameters compParams = new CompositeParameters(false).add("date", new DateParameters()).add("mdn", new MessageMDNParameters(mdn)).add("rand", new RandomParameters());
        return ParameterParser.parse(fileParam, compParams);
    }

    protected InputStream getMDNStream(MessageMDN mdn) throws IOException {
        StringBuffer mdnBuf = new StringBuffer();
        mdnBuf.append("Headers:" + System.getProperty("line.separator"));
        Enumeration headers = mdn.getHeaders().getAllHeaderLines();
        while (headers.hasMoreElements()) {
            String header = (String)headers.nextElement();
            mdnBuf.append(header).append(System.getProperty("line.separator"));
        }
        mdnBuf.append(System.getProperty("line.separator"));
        mdnBuf.append("Attributes:" + System.getProperty("line.separator"));
        for (Map.Entry<String, String> attrEntry : mdn.getAttributes().entrySet()) {
            mdnBuf.append((Object)attrEntry.getKey()).append(": ");
            mdnBuf.append(attrEntry.getValue()).append(System.getProperty("line.separator"));
        }
        mdnBuf.append("Text:" + System.getProperty("line.separator"));
        mdnBuf.append(mdn.getText());
        return new ByteArrayInputStream(mdnBuf.toString().getBytes());
    }
}

