/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.UUID;
import org.openas2.OpenAS2Exception;
import org.openas2.message.InvalidMessageException;
import org.openas2.util.ProfilerStub;
import org.openas2.util.Properties;

public class IOUtil {
    public static OutputStreamWriter getOutPutStreamWriter(String target, boolean createDirectories, String charsetName) throws IOException {
        if (charsetName == null) {
            charsetName = StandardCharsets.UTF_8.name();
        }
        Charset charSet = Charset.forName(charsetName);
        return new OutputStreamWriter((OutputStream)IOUtil.getFileOutPutStream(target, createDirectories), charSet);
    }

    public static FileOutputStream getFileOutPutStream(String target, boolean createDirectories) throws IOException {
        File tgtFile = new File(target);
        if (createDirectories) {
            String directory = tgtFile.getParent();
            File directoryFile = new File(directory);
            if (!directoryFile.exists() && !directoryFile.mkdirs()) {
                throw new IOException("Could not create directory: " + directory);
            }
            if (!directoryFile.isDirectory()) {
                throw new IOException("Invalid directory: " + directory);
            }
        }
        return new FileOutputStream(tgtFile);
    }

    public static File getDirectoryFile(String directory) throws IOException {
        File directoryFile = new File(directory);
        if (!directoryFile.exists() && !directoryFile.mkdirs()) {
            throw new IOException("Could not create directory: " + directory);
        }
        if (!directoryFile.isDirectory()) {
            throw new IOException("Invalid directory: " + directory);
        }
        return directoryFile;
    }

    public static String getTransferRate(int bytes, ProfilerStub stub) {
        StringBuffer buf = new StringBuffer();
        buf.append(bytes).append(" bytes in ");
        buf.append(stub.getCombined()).append(" at ");
        long time = stub.getDifference();
        if (time != 0L) {
            double stime = (double)time / 1000.0;
            long rate = Math.round((double)bytes / stime);
            buf.append(IOUtil.getTransferRate(rate));
        } else {
            buf.append(IOUtil.getTransferRate(bytes));
        }
        return buf.toString();
    }

    private static String getTransferRate(long bytesPerSecond) {
        StringBuffer buf = new StringBuffer();
        long kbytesPerSecond = bytesPerSecond / 1024L;
        if (bytesPerSecond < 1024L) {
            buf.append(bytesPerSecond).append(" Bps");
        } else if (kbytesPerSecond < 1024L) {
            buf.append(kbytesPerSecond).append(".").append(bytesPerSecond % 1024L).append(" KBps");
        } else {
            buf.append(kbytesPerSecond / 1024L).append(".").append(kbytesPerSecond % 1024L).append(" MBps");
        }
        return buf.toString();
    }

    public static File getUnique(File dir, String filename) {
        filename = IOUtil.cleanFilename(filename);
        return new File(dir, filename + "." + UUID.randomUUID());
    }

    public static String cleanFilename(String filename) {
        String reservedFilenameChars = Properties.getProperty("reservedFilenameCharacters", "<>:\"|?*");
        if (reservedFilenameChars != null && reservedFilenameChars.length() > 0) {
            String srchReplStr = reservedFilenameChars.replaceAll("\\[", "\\[").replaceAll("\\]", "\\]");
            filename = reservedFilenameChars.contains(":") && filename.matches("^[a-zA-Z]{1}:.*") ? filename.substring(0, 2) + filename.substring(2).replaceAll("[" + srchReplStr + "]", "") : filename.replaceAll("[" + srchReplStr + "]", "");
        }
        return filename;
    }

    public static void handleError(File file, String errorDirectory) throws OpenAS2Exception {
        File destFile = null;
        try {
            File errorDir = IOUtil.getDirectoryFile(errorDirectory);
            destFile = new File(errorDir, file.getName());
            destFile = IOUtil.moveFile(file, destFile, false, true);
        }
        catch (IOException ioe) {
            InvalidMessageException im = new InvalidMessageException("Failed to move " + file.getAbsolutePath() + " to error directory " + destFile.getAbsolutePath());
            im.initCause(ioe);
            throw im;
        }
        InvalidMessageException imMoved = new InvalidMessageException("Moved " + file.getAbsolutePath() + " to " + destFile.getAbsolutePath());
        imMoved.terminate();
    }

    public static File moveFile(File src, File dest, boolean overwrite, boolean rename) throws IOException {
        if (!overwrite && dest.exists()) {
            if (rename) {
                dest = IOUtil.getUnique(dest.getAbsoluteFile().getParentFile(), dest.getName());
            } else {
                throw new IOException("File already exists: " + dest);
            }
        }
        Files.copy(src.toPath(), dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
        if (!src.delete()) {
            dest.delete();
            throw new IOException("Move failed, unable to delete " + src);
        }
        return dest;
    }

    public static void deleteFile(File f) throws IOException {
        if (!f.exists()) {
            return;
        }
        boolean canUseNio = true;
        try {
            Class.forName("java.nio.file.Path");
        }
        catch (ClassNotFoundException e) {
            canUseNio = false;
        }
        if (canUseNio) {
            Path fp = f.toPath();
            Files.delete(fp);
        } else if (!f.delete()) {
            throw new IOException("Failed to delete file: " + f.getName());
        }
    }

    public static File[] getFiles(File dir, final String extensionFilter) {
        return dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith("." + extensionFilter);
            }
        });
    }
}

