/*
 * Decompiled with CFR 0.152.
 */
package org.openas2;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.openas2.Component;
import org.openas2.OpenAS2Exception;
import org.openas2.Session;
import org.openas2.params.InvalidParameterException;

public class BaseComponent
implements Component {
    private Map<String, String> parameters;
    private Session session;

    @Override
    public String getName() {
        String clippedName = this.getClass().getName();
        StringTokenizer classParts = new StringTokenizer(clippedName, ".", false);
        while (classParts.hasMoreTokens()) {
            clippedName = classParts.nextToken();
        }
        return clippedName;
    }

    public void setParameter(String key, String value) {
        this.getParameters().put(key, value);
    }

    public void setParameter(String key, int value) {
        this.setParameter(key, Integer.toString(value));
    }

    public String getParameter(String key, boolean required) throws InvalidParameterException {
        String parameter = this.getParameters().get(key);
        if (required && parameter == null) {
            throw new InvalidParameterException("Missing required parameter.", this, key, null);
        }
        return parameter;
    }

    public String getParameter(String key, String defaultValue) throws InvalidParameterException {
        String value = this.getParameter(key, false);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public int getParameterInt(String key, boolean required) throws InvalidParameterException {
        String value = this.getParameter(key, required);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return 0;
    }

    @Override
    public Map<String, String> getParameters() {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
        }
        return this.parameters;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public void init(Session session, Map<String, String> parameters) throws OpenAS2Exception {
        this.session = session;
        this.parameters = parameters;
    }

    @Override
    public void destroy() throws Exception {
    }
}

