/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.message;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import org.openas2.message.DataHistory;
import org.openas2.message.Message;
import org.openas2.message.MessageMDN;
import org.openas2.params.InvalidParameterException;
import org.openas2.partner.Partnership;

public abstract class BaseMessageMDN
implements MessageMDN {
    private static final long serialVersionUID = 1L;
    private DataHistory history;
    private InternetHeaders headers;
    private Partnership partnership;
    private Map<String, String> attributes;
    @Nonnull
    private Message message;
    private MimeBodyPart data;
    private String text;

    public BaseMessageMDN(@Nonnull Message msg) {
        this.message = msg;
        msg.setMDN(this);
    }

    @Override
    public void setAttribute(String key, String value) {
        this.getAttributes().put(key, value);
    }

    @Override
    public String getAttribute(String key) {
        return this.getAttributes().get(key);
    }

    @Override
    public Map<String, String> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        return this.attributes;
    }

    @Override
    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    @Override
    public MimeBodyPart getData() {
        return this.data;
    }

    @Override
    public void setData(MimeBodyPart data) {
        this.data = data;
    }

    @Override
    public void setHeader(String key, String value) {
        this.getHeaders().setHeader(key, value);
    }

    @Override
    public String getHeader(String key) {
        return this.getHeader(key, ", ");
    }

    @Override
    public String getHeader(String key, String delimiter) {
        return this.getHeaders().getHeader(key, delimiter);
    }

    @Override
    public InternetHeaders getHeaders() {
        if (this.headers == null) {
            this.headers = new InternetHeaders();
        }
        return this.headers;
    }

    @Override
    public void setHeaders(InternetHeaders headers) {
        this.headers = headers;
    }

    @Override
    public void copyHeaders(InternetHeaders srcHeaders) {
        Enumeration headerEn = srcHeaders.getAllHeaders();
        while (headerEn.hasMoreElements()) {
            Header header = (Header)headerEn.nextElement();
            this.setHeader(header.getName(), header.getValue());
        }
    }

    @Override
    @Nonnull
    public Message getMessage() {
        return this.message;
    }

    @Override
    public void setMessage(@Nonnull Message message) {
        this.message = message;
    }

    @Override
    public String getMessageID() {
        return this.getHeader("Message-ID");
    }

    @Override
    public void setMessageID(String messageID) {
        this.setHeader("Message-ID", messageID);
    }

    @Override
    public Partnership getPartnership() {
        if (this.partnership == null) {
            this.partnership = new Partnership();
        }
        return this.partnership;
    }

    @Override
    public void setPartnership(Partnership partnership) {
        this.partnership = partnership;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    @Override
    public void addHeader(String key, String value) {
        this.getHeaders().addHeader(key, value);
    }

    @Override
    public abstract String generateMessageID() throws InvalidParameterException;

    @Override
    public DataHistory getHistory() {
        if (this.history == null) {
            this.history = new DataHistory();
        }
        return this.history;
    }

    @Override
    public void setHistory(DataHistory history) {
        this.history = history;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("MDN From:").append(this.getPartnership().getReceiverIDs());
        buf.append("To:").append(this.getPartnership().getSenderIDs());
        Enumeration headerEn = this.getHeaders().getAllHeaders();
        buf.append(System.getProperty("line.separator") + "Headers:{");
        while (headerEn.hasMoreElements()) {
            Header header = (Header)headerEn.nextElement();
            buf.append(header.getName()).append("=").append(header.getValue());
            if (!headerEn.hasMoreElements()) continue;
            buf.append(", ");
        }
        buf.append("}");
        buf.append(System.getProperty("line.separator") + "Attributes:").append(this.getAttributes());
        buf.append(System.getProperty("line.separator") + "Text: " + System.getProperty("line.separator"));
        buf.append(this.getText()).append(System.getProperty("line.separator"));
        return buf.toString();
    }

    @Override
    public void updateMessageID() throws InvalidParameterException {
        this.setMessageID(this.generateMessageID());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.partnership = (Partnership)in.readObject();
        this.attributes = (Map)in.readObject();
        this.text = (String)in.readObject();
        try {
            this.headers = new InternetHeaders((InputStream)in);
            this.data = in.read() == 1 ? new MimeBodyPart((InputStream)in) : null;
        }
        catch (MessagingException me) {
            throw new IOException("Messaging exception: " + me.getMessage());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.partnership);
        out.writeObject(this.attributes);
        out.writeObject(this.text);
        Enumeration en = this.headers.getAllHeaderLines();
        while (en.hasMoreElements()) {
            out.writeBytes((String)en.nextElement() + "\r\n");
        }
        out.writeBytes("\r\n");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            if (this.data != null) {
                baos.write(1);
                this.data.writeTo((OutputStream)baos);
            } else {
                baos.write(0);
            }
        }
        catch (MessagingException e) {
            throw new IOException("Messaging exception: " + e.getMessage());
        }
        out.write(baos.toByteArray());
        baos.close();
    }
}

