/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.test;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import org.apache.commons.logging.LogFactory;
import org.openas2.XMLSession;
import org.openas2.cert.CertificateFactory;
import org.openas2.message.AS2Message;
import org.openas2.message.Message;
import org.openas2.params.InvalidParameterException;
import org.openas2.params.MessageParameters;
import org.openas2.test.TestConfig;
import org.openas2.util.AS2Util;
import org.openas2.util.ByteArrayDataSource;

public class MimeBodyPartEncodingTest {
    protected static OutputStream sysOut;
    protected static BufferedWriter sysOutWriter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        XMLSession session = null;
        int exitStatus = 0;
        System.setProperty("org.apache.commons.logging.Log", "org.openas2.logging.Log");
        LogFactory.getFactory().setAttribute("level", (Object)"TRACE");
        System.out.println("Current working directory: " + System.getProperty("user.dir") + System.getProperty("line.separator"));
        System.out.println("Logging prop: " + System.getProperty("org.apache.commons.logging.Log") + System.getProperty("line.separator"));
        File f = new File(TestConfig.TEST_OUTPUT_FOLDER);
        f.mkdirs();
        try {
            MimeBodyPartEncodingTest.write("Starting test..." + System.getProperty("line.separator"));
            MimeBodyPartEncodingTest.write("Loading configuration..." + System.getProperty("line.separator"));
            String configFile = "Server/config/config.xml";
            if (args.length == 1) {
                configFile = args[0];
            } else if (args.length > 1) {
                MimeBodyPartEncodingTest.write("Current working directory: " + System.getProperty("user.dir") + System.getProperty("line.separator"));
                MimeBodyPartEncodingTest.write("Usage:" + System.getProperty("line.separator"));
                MimeBodyPartEncodingTest.write("java org.openas2.app.OpenAS2Server <configuration file>" + System.getProperty("line.separator"));
                throw new Exception("Missing configuration file");
            }
            session = new XMLSession(configFile);
            MimeBodyPartEncodingTest.write("Entering test phase...." + System.getProperty("line.separator"));
            AS2Message msg = new AS2Message();
            MimeBodyPartEncodingTest.getPartnerInfo(msg);
            session.getPartnershipFactory().updatePartnership(msg, true);
            Map<String, String> attribs = msg.getPartnership().getAttributes();
            MimeBodyPartEncodingTest.write("Partnership attributes:\n" + msg.getPartnership().getName());
            for (String key : attribs.keySet()) {
                MimeBodyPartEncodingTest.write("\t" + key + " ::= " + attribs.get(key) + System.getProperty("line.separator"));
            }
            msg.setAttribute("filepath", TestConfig.TEST_SOURCE_FOLDER);
            msg.setAttribute("filename", TestConfig.TEST_DEFAULT_SRC_FILE_NAME);
            byte[] data = TestConfig.DEFAULT_MESSAGE_TEXT.getBytes();
            String contentType = "application/octet-stream";
            ByteArrayDataSource byteSource = new ByteArrayDataSource(data, contentType, null);
            MimeBodyPart body = new MimeBodyPart();
            body.setDataHandler(new DataHandler((DataSource)byteSource));
            body.setHeader("Content-Type", contentType);
            String contentDisposition = "Attachment; filename=\"" + msg.getAttribute("filename") + "\"";
            body.setHeader("Content-Disposition", contentDisposition);
            msg.setContentDisposition(contentDisposition);
            String contentTxfrEncoding = msg.getPartnership().getAttribute("content_transfer_encoding");
            if (contentTxfrEncoding == null) {
                contentTxfrEncoding = "binary";
            }
            MimeBodyPartEncodingTest.write("Using Content-Transfer-Encoding: " + contentTxfrEncoding + System.getProperty("line.separator"));
            body.addHeader("Content-Transfer-Encoding", contentTxfrEncoding);
            msg.setData(body);
            session.getPartnershipFactory().updatePartnership(msg, true);
            msg.updateMessageID();
            CertificateFactory certFx = session.getCertificateFactory();
            X509Certificate senderCert = certFx.getCertificate(msg, "sender");
            PrivateKey senderKey = certFx.getPrivateKey(msg, senderCert);
            String digest = msg.getPartnership().getAttribute("sign");
            System.out.println("Params for creating signed body part:: SIGN DIGEST: " + digest + "\n CERT ALG NAME EXTRACTED: " + senderCert.getSigAlgName() + "\n CERT PUB KEY ALG NAME EXTRACTED: " + senderCert.getPublicKey().getAlgorithm() + msg.getLogMsgID());
            String testFile = TestConfig.TEST_OUTPUT_FOLDER + "/" + TestConfig.TEST_DEFAULT_TGT_FILE_NAME + ".presigning";
            FileOutputStream fos = new FileOutputStream(testFile);
            MimeBodyPartEncodingTest.write(fos, body);
            fos.close();
            System.out.println("MimeBodyPart written to: " + testFile);
            boolean isRemoveCmsAlgorithmProtectionAttr = "true".equalsIgnoreCase(msg.getPartnership().getAttribute("remove_cms_algorithm_protection_attrib"));
            MimeBodyPart signedMbp = AS2Util.getCryptoHelper().sign(body, senderCert, senderKey, digest, contentTxfrEncoding, msg.getPartnership().isRenameDigestToOldName(), isRemoveCmsAlgorithmProtectionAttr);
            testFile = TestConfig.TEST_OUTPUT_FOLDER + "/" + TestConfig.TEST_DEFAULT_TGT_FILE_NAME + ".signed";
            fos = new FileOutputStream(testFile);
            MimeBodyPartEncodingTest.write(fos, signedMbp);
            fos.close();
            System.out.println("MimeBodyPart written to: " + testFile);
            String algorithm = msg.getPartnership().getAttribute("encrypt");
            X509Certificate receiverCert = certFx.getCertificate(msg, "receiver");
            signedMbp = AS2Util.getCryptoHelper().encrypt(signedMbp, receiverCert, algorithm, contentTxfrEncoding);
            testFile = TestConfig.TEST_OUTPUT_FOLDER + "/" + TestConfig.TEST_DEFAULT_TGT_FILE_NAME + ".encrypted";
            fos = new FileOutputStream(testFile);
            MimeBodyPartEncodingTest.write(fos, signedMbp);
            fos.close();
            System.out.println("MimeBodyPart written to: " + testFile);
        }
        catch (Exception e) {
            exitStatus = -1;
            e.printStackTrace();
        }
        catch (Error err) {
            exitStatus = -1;
            err.printStackTrace();
        }
        finally {
            MimeBodyPartEncodingTest.write("OpenAS2 test has shut down." + System.getProperty("line.separator"));
            System.exit(exitStatus);
        }
    }

    public static void write(OutputStream os, MimeBodyPart mbp) throws MessagingException, IOException {
        os.write((System.getProperty("line.separator") + "========BEGIN MIMEBODYPART=========" + System.getProperty("line.separator")).getBytes());
        mbp.writeTo(os);
        os.write((System.getProperty("line.separator") + "========END MIMEBODYPART=========" + System.getProperty("line.separator")).getBytes());
    }

    public static void write(String msg) {
        if (sysOutWriter == null) {
            sysOutWriter = new BufferedWriter(new OutputStreamWriter(System.out));
        }
        try {
            sysOutWriter.write(msg);
            sysOutWriter.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void getPartnerInfo(Message msg) throws InvalidParameterException {
        MessageParameters params = new MessageParameters(msg);
        String defaults = System.getProperty("partnership.defaults", TestConfig.DEFAULT_PARTNER_INFO);
        params.setParameters(defaults);
    }
}

