/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.powershell.internal.service;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.connectors.commons.template.config.ConnectorConfig;
import org.mule.connectors.commons.template.connection.ConnectorConnection;
import org.mule.connectors.commons.template.service.DefaultConnectorService;
import org.mule.extension.powershell.internal.config.PowershellConfiguration;
import org.mule.extension.powershell.internal.connection.PowershellConnection;
import org.mule.extension.powershell.internal.error.PowershellException;
import org.mule.extension.powershell.internal.service.PowershellService;
import org.mule.runtime.core.api.util.IOUtils;

public class PowershellServiceImpl
extends DefaultConnectorService<PowershellConfiguration, PowershellConnection>
implements PowershellService {
    public PowershellServiceImpl(PowershellConfiguration config, PowershellConnection connection) {
        super((ConnectorConfig)config, (ConnectorConnection)connection);
    }

    @Override
    public String executeScriptFile(InputStream fileContent, Map<String, String> parameters) {
        String finalCommand = "function myfunc" + System.lineSeparator() + "{" + System.lineSeparator();
        String command = PowershellServiceImpl.readStream(fileContent);
        if (parameters == null) {
            finalCommand = finalCommand + command + System.lineSeparator() + "}" + System.lineSeparator() + " myfunc " + System.lineSeparator() + "EOF" + System.lineSeparator();
        } else {
            finalCommand = finalCommand + "Param(" + parameters.keySet().stream().map(key -> "[Parameter(Mandatory=$true)]$" + key).collect(Collectors.joining("," + System.lineSeparator())) + ")" + System.lineSeparator() + command + System.lineSeparator() + "}" + System.lineSeparator() + " myfunc ";
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                finalCommand = finalCommand + "-" + entry.getKey() + " " + entry.getValue() + " ";
            }
        }
        return Optional.ofNullable(this.execute(finalCommand)).orElse("Exception occured while processing script");
    }

    @Override
    public String executeCommand(String command) {
        return Optional.ofNullable(this.execute("function myfunc{" + System.lineSeparator() + command + System.lineSeparator() + "}" + System.lineSeparator() + " myfunc " + System.lineSeparator() + "EOF" + System.lineSeparator())).orElse("Exception occured while processing command");
    }

    private String execute(String command) {
        InputStream in = null;
        Channel channel = null;
        OutputStream out = null;
        try {
            String output;
            channel = ((PowershellConnection)this.getConnection()).getSession().openChannel("exec");
            ((ChannelExec)channel).setCommand(((PowershellConnection)this.getConnection()).getPowershellCommand());
            out = channel.getOutputStream();
            in = channel.getInputStream();
            channel.connect();
            String finalCommand = command + System.lineSeparator() + "EOF" + System.lineSeparator();
            out.write(finalCommand.getBytes());
            out.flush();
            String string = output = IOUtils.toString((InputStream)in).split("EOF")[1];
            return string;
        }
        catch (Exception ex) {
            throw new PowershellException(ex);
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readStream(InputStream stream) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
            String line;
            StringBuilder builder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                builder.append(line);
                builder.append(System.getProperty("line.separator"));
            }
            String string = builder.toString().replaceAll("\\p{Pd}", "-").trim();
            return string;
        }
        catch (IOException e) {
            throw new PowershellException(e);
        }
    }
}

