/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.powershell.internal.connection.provider;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.util.Properties;
import org.mule.connectors.commons.template.connection.ConnectorConnectionProvider;
import org.mule.extension.powershell.api.OperativeSystem;
import org.mule.extension.powershell.internal.connection.PowershellConnection;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Password;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.sdk.api.annotation.semantics.connectivity.ExcludeFromConnectivitySchema;
import org.mule.sdk.api.annotation.semantics.connectivity.Host;
import org.mule.sdk.api.annotation.semantics.security.Username;

@Alias(value="powershell")
public class PowershellConnectionProvider
extends ConnectorConnectionProvider<PowershellConnection>
implements ConnectionProvider<PowershellConnection> {
    @Parameter
    @Placement(order=1)
    @DisplayName(value="IPAddress")
    @Host
    private String host;
    @Parameter
    @Placement(order=2)
    @DisplayName(value="UserName")
    @Username
    private String username;
    @Parameter
    @Placement(order=3)
    @Password
    @DisplayName(value="Password")
    @org.mule.sdk.api.annotation.semantics.security.Password
    private String password;
    @Placement(order=4)
    @Parameter
    @Optional(defaultValue="WINDOWS")
    @ExcludeFromConnectivitySchema
    private OperativeSystem operativeSystem;

    public PowershellConnection connect() throws ConnectionException {
        try {
            Properties configProperties = new Properties();
            configProperties.put("StrictHostKeyChecking", "no");
            Session session = new JSch().getSession(this.username, this.host, 22);
            session.setPassword(this.password);
            session.setConfig(configProperties);
            session.connect();
            PowershellConnection powershellSession = new PowershellConnection(session);
            if (this.operativeSystem.equals((Object)OperativeSystem.LINUX)) {
                powershellSession.setPowershellCommand("pwsh -command \"\\$lines=while((\\$x=read-host) -ne 'EOF'){\\$x};\\$lines | Out-String | Invoke-Expression\"");
            } else {
                powershellSession.setPowershellCommand("powershell -command \"$lines=while(($x=read-host) -ne 'EOF'){$x};$lines | Out-String | Invoke-Expression\"");
            }
            return powershellSession;
        }
        catch (JSchException e) {
            throw new ConnectionException((Throwable)e);
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public OperativeSystem getOperativeSystem() {
        return this.operativeSystem;
    }

    public void setOperativeSystem(OperativeSystem operativeSystem) {
        this.operativeSystem = operativeSystem;
    }
}

