/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.powershell.internal.operation;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.mule.connectors.atlantic.commons.builder.execution.ExecutionBuilder;
import org.mule.connectors.commons.template.operation.ConnectorOperations;
import org.mule.extension.powershell.internal.config.PowershellConfiguration;
import org.mule.extension.powershell.internal.connection.PowershellConnection;
import org.mule.extension.powershell.internal.error.PowershellException;
import org.mule.extension.powershell.internal.error.provider.PowershellErrorTypeProvider;
import org.mule.extension.powershell.internal.service.ExceptionHandling;
import org.mule.extension.powershell.internal.service.PowershellService;
import org.mule.extension.powershell.internal.service.PowershellServiceImpl;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Throws(value={PowershellErrorTypeProvider.class})
public class PowershellOperations
extends ConnectorOperations<PowershellConfiguration, PowershellConnection, PowershellService> {
    private static final Logger logger = LoggerFactory.getLogger(PowershellOperations.class);
    public static final String LINE_SEPARATOR = System.lineSeparator();
    private static final String START_OF_LOGGING = "=========START OF OPERATION INPUT LOG=========";
    public static final String END_OF_LOGGING = "=========END LOG=========";
    private static final String DELIMITER = "-----------------------------------";

    public PowershellOperations() {
        super(PowershellServiceImpl::new);
    }

    @MediaType(value="text/plain")
    @Summary(value="This operation executes the script file.")
    public String executeScriptFile(@Config PowershellConfiguration config, @Connection PowershellConnection connection, @Content @Summary(value="The file which contains the script.") InputStream fileContent, @Optional Map<String, String> parameters) {
        if (logger.isDebugEnabled()) {
            String stringContent = IOUtils.toString((InputStream)fileContent);
            StringBuilder debugMessage = new StringBuilder();
            debugMessage.append(LINE_SEPARATOR).append(START_OF_LOGGING).append(LINE_SEPARATOR).append(String.format("Executing script file:%n  %s", stringContent));
            if (parameters != null && !parameters.isEmpty()) {
                debugMessage.append(DELIMITER).append(LINE_SEPARATOR).append("With the following parameters:").append(LINE_SEPARATOR).append(parameters.toString()).append(LINE_SEPARATOR);
            }
            debugMessage.append(END_OF_LOGGING);
            logger.debug(debugMessage.toString());
            fileContent = new ByteArrayInputStream(stringContent.getBytes(StandardCharsets.UTF_8));
        }
        return (String)this.newExecutionBuilder(config, connection).execute(PowershellService::executeScriptFile).withParam((Object)fileContent).withParam(parameters).withParam((Object)ExceptionHandling.NO_EXECUTION_EXCEPTION_HANDLING);
    }

    @MediaType(value="text/plain")
    @DisplayName(value="Execute script file (exception handling enabled)")
    @Summary(value="This operation executes the script file and throws Powershell related exceptions if any.")
    public String executeScriptFileWithExceptionHandling(@Config PowershellConfiguration config, @Connection PowershellConnection connection, @Content @Summary(value="The file which contains the script.") InputStream fileContent, @Optional Map<String, String> parameters) {
        if (logger.isDebugEnabled()) {
            String stringContent = IOUtils.toString((InputStream)fileContent);
            StringBuilder debugMessage = new StringBuilder();
            debugMessage.append(LINE_SEPARATOR).append(START_OF_LOGGING).append(LINE_SEPARATOR).append(String.format("Executing script file:%n  %s", stringContent));
            if (parameters != null && !parameters.isEmpty()) {
                debugMessage.append(DELIMITER).append(LINE_SEPARATOR).append("With the following parameters:").append(LINE_SEPARATOR).append(parameters.toString()).append(LINE_SEPARATOR);
            }
            debugMessage.append(END_OF_LOGGING);
            logger.debug(debugMessage.toString());
            fileContent = new ByteArrayInputStream(stringContent.getBytes(StandardCharsets.UTF_8));
        }
        return (String)((ExecutionBuilder)this.newExecutionBuilder(config, connection).withExceptionHandler(PowershellException.class, exception -> {
            throw exception;
        })).execute(PowershellService::executeScriptFile).withParam((Object)fileContent).withParam(parameters).withParam((Object)ExceptionHandling.EXECUTION_EXCEPTION_HANDLING);
    }

    @MediaType(value="text/plain")
    @Summary(value="This operation executes the command on the machine.")
    public String executeCommand(@Config PowershellConfiguration config, @Connection PowershellConnection connection, String command) {
        if (logger.isDebugEnabled()) {
            String debugMessage = String.format("%s%s%sExecuting powershell command :%n  %s%s%s", LINE_SEPARATOR, START_OF_LOGGING, LINE_SEPARATOR, command, LINE_SEPARATOR, END_OF_LOGGING);
            logger.debug(debugMessage);
        }
        return (String)this.newExecutionBuilder(config, connection).execute(PowershellService::executeCommand).withParam((Object)command).withParam((Object)ExceptionHandling.NO_EXECUTION_EXCEPTION_HANDLING);
    }

    @MediaType(value="text/plain")
    @DisplayName(value="Execute command (exception handling enabled)")
    @Summary(value="This operation executes the command on the target machine and throws powershell related\nexceptions if any.")
    public String executeCommandExceptionHandlingEnabled(@Config PowershellConfiguration config, @Connection PowershellConnection connection, String command) {
        if (logger.isDebugEnabled()) {
            String debugMessage = String.format("%s%s%sExecuting powershell command :%n  %s%s%s", LINE_SEPARATOR, START_OF_LOGGING, LINE_SEPARATOR, command, LINE_SEPARATOR, END_OF_LOGGING);
            logger.debug(debugMessage);
        }
        return (String)((ExecutionBuilder)this.newExecutionBuilder(config, connection).withExceptionHandler(PowershellException.class, exception -> {
            throw exception;
        })).execute(PowershellService::executeCommand).withParam((Object)command).withParam((Object)ExceptionHandling.EXECUTION_EXCEPTION_HANDLING);
    }
}

