/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.powershell.internal.service;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.connectors.commons.template.config.ConnectorConfig;
import org.mule.connectors.commons.template.connection.ConnectorConnection;
import org.mule.connectors.commons.template.service.DefaultConnectorService;
import org.mule.extension.powershell.internal.config.PowershellConfiguration;
import org.mule.extension.powershell.internal.connection.PowershellConnection;
import org.mule.extension.powershell.internal.error.PowershellErrorType;
import org.mule.extension.powershell.internal.error.PowershellException;
import org.mule.extension.powershell.internal.operation.PowershellOperations;
import org.mule.extension.powershell.internal.service.ExceptionHandling;
import org.mule.extension.powershell.internal.service.PowershellService;
import org.mule.runtime.core.api.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PowershellServiceImpl
extends DefaultConnectorService<PowershellConfiguration, PowershellConnection>
implements PowershellService {
    private static final String MYFUNC = " myfunc ";
    private static final String MID_LOGGING = " =========MIDDLEWARE LOG=========";
    private static final Logger logger = LoggerFactory.getLogger(PowershellServiceImpl.class);

    public PowershellServiceImpl(PowershellConfiguration config, PowershellConnection connection) {
        super((ConnectorConfig)config, (ConnectorConnection)connection);
    }

    @Override
    public String executeScriptFile(InputStream fileContent, Map<String, String> parameters, ExceptionHandling exceptionHandling) {
        StringBuilder finalCommand = new StringBuilder("function myfunc" + System.lineSeparator() + "{" + System.lineSeparator());
        String command = PowershellServiceImpl.readStream(fileContent);
        if (parameters == null) {
            finalCommand.append(command).append(System.lineSeparator()).append("}").append(System.lineSeparator()).append(MYFUNC).append(System.lineSeparator()).append("EOF").append(System.lineSeparator());
        } else {
            finalCommand.append("Param(").append(parameters.keySet().stream().map(key -> "[Parameter(Mandatory=$true)]$" + key).collect(Collectors.joining("," + System.lineSeparator()))).append(")").append(System.lineSeparator()).append(command).append(System.lineSeparator()).append("}").append(System.lineSeparator()).append(MYFUNC);
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                finalCommand.append("-").append(entry.getKey()).append(" ").append(entry.getValue()).append(" ");
            }
        }
        return Optional.ofNullable(this.execute(finalCommand.toString(), exceptionHandling)).orElse("Exception occurred while processing script");
    }

    @Override
    public String executeCommand(String command, ExceptionHandling exceptionHandling) {
        return Optional.ofNullable(this.execute("function myfunc{" + System.lineSeparator() + command + System.lineSeparator() + "}" + System.lineSeparator() + MYFUNC + System.lineSeparator() + "EOF" + System.lineSeparator(), exceptionHandling)).orElse("Exception occurred while processing command");
    }

    private String execute(String command, ExceptionHandling exceptionHandling) {
        InputStream in = null;
        InputStream errorStream = null;
        Channel channel = null;
        OutputStream out = null;
        try {
            String exceptionMessage;
            channel = ((PowershellConnection)this.getConnection()).getSession().openChannel("exec");
            ((ChannelExec)channel).setCommand(((PowershellConnection)this.getConnection()).getPowershellCommand());
            out = channel.getOutputStream();
            in = channel.getInputStream();
            channel.connect();
            String finalCommand = command + System.lineSeparator() + "EOF" + System.lineSeparator();
            if (logger.isDebugEnabled()) {
                String debugMessage = String.format("%s%s%sExecuting powershell command:%n  %s%s%s", PowershellOperations.LINE_SEPARATOR, MID_LOGGING, PowershellOperations.LINE_SEPARATOR, finalCommand, PowershellOperations.LINE_SEPARATOR, "=========END LOG=========");
                logger.debug(debugMessage);
            }
            out.write(finalCommand.getBytes());
            out.flush();
            if (exceptionHandling.equals((Object)ExceptionHandling.EXECUTION_EXCEPTION_HANDLING) && !(exceptionMessage = IOUtils.toString((InputStream)(errorStream = ((ChannelExec)channel).getErrStream()))).isEmpty()) {
                throw new PowershellException(exceptionMessage, PowershellErrorType.EXECUTION_EXCEPTION);
            }
            String string = IOUtils.toString((InputStream)in).split("EOF")[1];
            return string;
        }
        catch (PowershellException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new PowershellException(ex);
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readStream(InputStream stream) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
            String line;
            StringBuilder builder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                builder.append(line);
                builder.append(System.getProperty("line.separator"));
            }
            String string = builder.toString().replaceAll("\\p{Pd}", "-").trim();
            return string;
        }
        catch (IOException e) {
            throw new PowershellException(e);
        }
    }
}

