/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.redis.internal.connection;

import java.io.IOException;
import org.mule.extension.redis.internal.connection.RedisConnection;
import org.mule.extension.redis.internal.error.exceptions.UnableToCloseConnection;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisCluster;

public class JedisClusteredConnection
extends RedisConnection {
    private static final Logger logger = LoggerFactory.getLogger(JedisClusteredConnection.class);
    private JedisCluster jedisCluster;

    public JedisCluster getJedisCluster() {
        return this.jedisCluster;
    }

    public JedisClusteredConnection(String name, JedisCluster jedisCluster, ObjectSerializer objectSerializer, SchedulerService schedulerService, SchedulerConfig schedulerConfig) {
        super(name, objectSerializer, schedulerService, schedulerConfig);
        this.jedisCluster = jedisCluster;
    }

    public JedisClusteredConnection(String name, JedisCluster jedisCluster, Integer entryTTL, ObjectSerializer objectSerializer, SchedulerService schedulerService, SchedulerConfig schedulerConfig) {
        super(name, entryTTL, objectSerializer, schedulerService, schedulerConfig);
        this.jedisCluster = jedisCluster;
    }

    @Override
    public void close() {
        super.close();
        try {
            if (this.jedisCluster != null) {
                this.jedisCluster.close();
            }
        }
        catch (IOException e) {
            logger.error("Unable to end connection.", (Throwable)e);
            throw new UnableToCloseConnection("Unable to end connection.", e);
        }
    }

    @Override
    public boolean isValid() {
        return this.jedisCluster != null;
    }

    @Override
    public void validate() {
        super.validate();
        this.jedisCluster.echo("ping");
    }
}

