/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.redis.internal.connection;

import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import org.mule.extension.redis.internal.connection.RedisObjectStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisObjectStoreExpiryTask
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(RedisObjectStoreExpiryTask.class);
    private RedisObjectStore redisObjectStore;

    public RedisObjectStoreExpiryTask(RedisObjectStore redisObjectStore) {
        this.redisObjectStore = redisObjectStore;
    }

    @Override
    public void run() {
        this.expire();
    }

    public void expire() {
        try {
            List<String> keys = this.redisObjectStore.allKeys();
            int excess = this.redisObjectStore.getMaxEntries() != null ? keys.size() - this.redisObjectStore.getMaxEntries() : 0;
            PriorityQueue<String> sortedMaxEntriesKeys = null;
            if (excess > 0) {
                sortedMaxEntriesKeys = new PriorityQueue<String>(excess, Comparator.comparing(this.redisObjectStore.getService()::ttl));
                for (String key : keys) {
                    sortedMaxEntriesKeys.offer(key);
                }
            }
            if (sortedMaxEntriesKeys != null) {
                String key = (String)sortedMaxEntriesKeys.poll();
                while (key != null && excess > 0) {
                    this.redisObjectStore.remove(key);
                    --excess;
                    key = sortedMaxEntriesKeys.poll();
                }
            }
        }
        catch (Exception e) {
            logger.warn("Running expiry on Custom Redis Object Store threw " + e + ":" + e.getMessage(), (Throwable)e);
        }
    }
}

