/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.redis.internal.connection.provider;

import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.mule.connectors.commons.template.connection.ConnectorConnectionProvider;
import org.mule.extension.redis.internal.connection.JedisPoolConnection;
import org.mule.extension.redis.internal.connection.RedisConnection;
import org.mule.extension.redis.internal.connection.param.NonClusteredConnectionParams;
import org.mule.extension.redis.internal.connection.param.PoolConfigParams;
import org.mule.extension.redis.internal.connection.provider.PoolConverter;
import org.mule.extension.redis.internal.stereotype.ObjectStoreConnectionStereotype;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.stereotype.Stereotype;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisPool;

@Alias(value="nonclustered")
@DisplayName(value="NonClustered")
@Stereotype(value=ObjectStoreConnectionStereotype.class)
public class NonClusteredConnectionProvider
extends ConnectorConnectionProvider<RedisConnection>
implements CachedConnectionProvider<RedisConnection> {
    private static final Logger logger = LoggerFactory.getLogger(NonClusteredConnectionProvider.class);
    @RefName
    private String configName;
    @Inject
    @Named(value="_muleDefaultObjectSerializer")
    private ObjectSerializer objectSerializer;
    @Inject
    private SchedulerService schedulerService;
    @Inject
    @Named(value="_muleSchedulerBaseConfig")
    private SchedulerConfig schedulerConfig;
    @ParameterGroup(name="Connection")
    @Placement(order=1)
    private NonClusteredConnectionParams pooledConnectionParams;
    @ParameterGroup(name="Pooling")
    @Placement(order=2)
    private PoolConfigParams poolConfig;

    public RedisConnection connect() {
        JedisPool jedisPool = new JedisPool((GenericObjectPoolConfig)PoolConverter.getJedisPoolConfig(this.poolConfig), this.pooledConnectionParams.getHost(), this.pooledConnectionParams.getPort(), this.pooledConnectionParams.getConnectionTimeout(), this.pooledConnectionParams.getPassword());
        logger.info(String.format("Redis connector ready, host: %s, port: %d, timeout: %d, password: %s, pool config: %s", this.pooledConnectionParams.getHost(), this.pooledConnectionParams.getPort(), this.pooledConnectionParams.getConnectionTimeout(), StringUtils.repeat((String)"*", (int)StringUtils.length((String)this.pooledConnectionParams.getPassword())), ToStringBuilder.reflectionToString((Object)this.poolConfig, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE)));
        JedisPoolConnection jedisPoolConnection = new JedisPoolConnection(this.configName, jedisPool, this.pooledConnectionParams.getEntryTTL(), this.objectSerializer, this.schedulerService, this.schedulerConfig);
        jedisPoolConnection.start();
        return jedisPoolConnection;
    }

    public void disconnect(RedisConnection conn) {
        conn.disconnect();
    }

    public ConnectionValidationResult validate(RedisConnection conn) {
        try {
            conn.validate();
            return ConnectionValidationResult.success();
        }
        catch (Exception e) {
            return ConnectionValidationResult.failure((String)"Connection is no longer valid", (Exception)e);
        }
    }
}

