/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.redis.internal.service.factory;

import org.mule.extension.redis.internal.connection.JedisClusteredConnection;
import org.mule.extension.redis.internal.connection.JedisPoolConnection;
import org.mule.extension.redis.internal.connection.RedisConnection;
import org.mule.extension.redis.internal.service.RedisClientAdapter;
import org.mule.extension.redis.internal.service.cluster.ClusteredClientAdapter;
import org.mule.extension.redis.internal.service.noncluster.JedisClientAdapter;

public class RedisClientAdapterFactory {
    public RedisClientAdapter getRedisClientAdapter(RedisConnection redisConnection) {
        if (redisConnection instanceof JedisPoolConnection) {
            return new JedisClientAdapter(((JedisPoolConnection)redisConnection).getJedisPool().getResource());
        }
        if (redisConnection instanceof JedisClusteredConnection) {
            return new ClusteredClientAdapter(((JedisClusteredConnection)redisConnection).getJedisCluster());
        }
        throw new IllegalArgumentException("Invalid instance of redis connection.");
    }
}

