/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.redis.internal.utils;

import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import redis.clients.util.SafeEncoder;

public abstract class RedisUtils {
    private static final Log logger = LogFactory.getLog(RedisUtils.class);

    protected RedisUtils() {
        throw new UnsupportedOperationException("do not instantiate");
    }

    public static byte[] toBytes(String string, String encoding) {
        try {
            if (string == null) {
                return new byte[0];
            }
            return string.getBytes(encoding);
        }
        catch (UnsupportedEncodingException uee) {
            logger.error((Object)String.format("Failed to get bytes from %s with encoding %s, using default encoding", string, encoding), (Throwable)uee);
            throw new IllegalArgumentException(String.format("Failed to get bytes from %s with encoding %s.", string, encoding), uee);
        }
    }

    public static byte[][] getPatternsFromChannels(List<String> channels) {
        byte[][] patterns = new byte[channels.size()][];
        for (int i = 0; i < channels.size(); ++i) {
            patterns[i] = SafeEncoder.encode((String)channels.get(i));
        }
        return patterns;
    }
}

