/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.redis.internal.connection;

import org.mule.extension.redis.internal.connection.RedisConnection;
import org.mule.extension.redis.internal.error.exceptions.UnableToCloseConnection;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisPool;

public class JedisPoolConnection
extends RedisConnection {
    private static final Logger logger = LoggerFactory.getLogger(JedisPoolConnection.class);
    private JedisPool jedisPool;

    public JedisPool getJedisPool() {
        return this.jedisPool;
    }

    public JedisPoolConnection(String name, JedisPool jedisPool, ObjectSerializer objectSerializer, SchedulerService schedulerService, SchedulerConfig schedulerConfig) {
        super(name, objectSerializer, schedulerService, schedulerConfig);
        this.jedisPool = jedisPool;
    }

    public JedisPoolConnection(String name, JedisPool jedisPool, Integer entryTTL, ObjectSerializer objectSerializer, SchedulerService schedulerService, SchedulerConfig schedulerConfig) {
        super(name, entryTTL, objectSerializer, schedulerService, schedulerConfig);
        this.jedisPool = jedisPool;
    }

    @Override
    public void close() {
        super.close();
        try {
            if (this.jedisPool != null) {
                this.jedisPool.close();
            }
        }
        catch (Exception e) {
            logger.error("Unable to end connection.", (Throwable)e);
            throw new UnableToCloseConnection("Unable to end connection.", e);
        }
    }

    @Override
    public boolean isValid() {
        return this.jedisPool != null;
    }

    @Override
    public void validate() {
        super.validate();
        this.jedisPool.getResource().echo("ping");
    }
}

