/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.redis.internal.connection;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.mule.connectors.commons.template.connection.ConnectorConnection;
import org.mule.extension.redis.internal.connection.RedisObjectStore;
import org.mule.extension.redis.internal.error.exceptions.UnableToSendRequestException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.api.store.ObjectStoreSettings;

public abstract class RedisConnection
implements ConnectorConnection,
ObjectStoreManager,
Startable,
Stoppable {
    private Map<String, RedisObjectStore> objectStores = new HashMap<String, RedisObjectStore>();
    private Integer entryTTL;
    private final Object lock = new Object();
    private ObjectSerializer objectSerializer;
    private Scheduler scheduler;
    private SchedulerService schedulerService;
    private SchedulerConfig schedulerConfig;
    private String name;

    public Integer getEntryTTL() {
        return this.entryTTL;
    }

    public void setEntryTTL(Integer entryTTL) {
        this.entryTTL = entryTTL;
    }

    public RedisConnection(String name, ObjectSerializer objectSerializer, SchedulerService schedulerService, SchedulerConfig schedulerConfig) {
        this.name = name;
        this.objectSerializer = objectSerializer;
        this.schedulerService = schedulerService;
        this.schedulerConfig = schedulerConfig;
    }

    public RedisConnection(String name, Integer entryTTL, ObjectSerializer objectSerializer, SchedulerService schedulerService, SchedulerConfig schedulerConfig) {
        this.name = name;
        this.entryTTL = entryTTL;
        this.objectSerializer = objectSerializer;
        this.schedulerService = schedulerService;
        this.schedulerConfig = schedulerConfig;
    }

    public void close() {
        this.objectStores.values().forEach(RedisObjectStore::close);
    }

    public abstract boolean isValid();

    public void validate() {
        if (!this.isValid()) {
            throw new RuntimeException("Invalid connection");
        }
    }

    public void disconnect() {
        this.stop();
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectStore<Serializable> getObjectStore(String name) {
        Object object = this.lock;
        synchronized (object) {
            RedisObjectStore store = this.objectStores.get(name);
            if (store == null) {
                throw new IllegalArgumentException("An Object Store was not defined for name " + name);
            }
            return store;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectStore<Serializable> createObjectStore(String name, ObjectStoreSettings settings) {
        Object object = this.lock;
        synchronized (object) {
            RedisObjectStore store = this.objectStores.get(name);
            if (store != null) {
                throw new IllegalArgumentException("An Object Store was already defined for name " + name);
            }
            try {
                store = new RedisObjectStore(this, settings, name);
                store.open();
            }
            catch (ObjectStoreException e) {
                throw new UnableToSendRequestException(e.getMessage(), (Exception)((Object)e));
            }
            this.objectStores.put(name, store);
            return store;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectStore<Serializable> getOrCreateObjectStore(String name, ObjectStoreSettings settings) {
        Object object = this.lock;
        synchronized (object) {
            RedisObjectStore store;
            if (this.objectStores.containsKey(name)) {
                store = this.objectStores.get(name);
            } else {
                try {
                    store = new RedisObjectStore(this, settings, name);
                    store.open();
                }
                catch (ObjectStoreException e) {
                    throw new UnableToSendRequestException(e.getMessage(), (Exception)((Object)e));
                }
                this.objectStores.put(name, store);
            }
            return store;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeStore(String name) throws ObjectStoreException {
        Object object = this.lock;
        synchronized (object) {
            if (this.objectStores.containsKey(name)) {
                this.objectStores.get(name).clear();
                this.objectStores.remove(name);
            }
        }
    }

    public void start() {
        if (this.scheduler == null) {
            this.scheduler = this.schedulerService.customScheduler(this.schedulerConfig.withName(this.name + "-Monitor").withMaxConcurrentTasks(1));
        }
    }

    public void stop() {
        this.scheduler.stop();
    }

    public ObjectSerializer getObjectSerializer() {
        return this.objectSerializer;
    }

    public Scheduler getScheduler() {
        if (this.scheduler == null) {
            this.scheduler = this.schedulerService.customScheduler(this.schedulerConfig.withName(this.name + "-Monitor").withMaxConcurrentTasks(1));
        }
        return this.scheduler;
    }
}

