/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.redis.internal.connection.provider;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.mule.connectors.commons.template.connection.ConnectorConnectionProvider;
import org.mule.extension.redis.internal.connection.JedisClusteredConnection;
import org.mule.extension.redis.internal.connection.RedisConnection;
import org.mule.extension.redis.internal.connection.param.ClusteredConnectionParams;
import org.mule.extension.redis.internal.connection.param.PoolConfigParams;
import org.mule.extension.redis.internal.connection.provider.PoolConverter;
import org.mule.extension.redis.internal.stereotype.ObjectStoreConnectionStereotype;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.stereotype.Stereotype;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;

@Alias(value="clustered")
@DisplayName(value="Clustered")
@Stereotype(value=ObjectStoreConnectionStereotype.class)
public class ClusteredConnectionProvider
extends ConnectorConnectionProvider<RedisConnection>
implements CachedConnectionProvider<RedisConnection> {
    private static final Logger logger = LoggerFactory.getLogger(ClusteredConnectionProvider.class);
    @RefName
    private String configName;
    @Inject
    @Named(value="_muleDefaultObjectSerializer")
    private ObjectSerializer objectSerializer;
    @Inject
    private SchedulerService schedulerService;
    @Inject
    @Named(value="_muleSchedulerBaseConfig")
    private SchedulerConfig schedulerConfig;
    @ParameterGroup(name="Connection")
    @Placement(order=1)
    private ClusteredConnectionParams clusterConnectionParams;
    @ParameterGroup(name="Pooling")
    @Placement(order=2)
    private PoolConfigParams poolConfigParams;

    public RedisConnection connect() throws ConnectionException {
        String clusterHosts = this.clusterConnectionParams.getClusterHosts();
        int connectionTimeout = this.clusterConnectionParams.getConnectionTimeout();
        HashSet<HostAndPort> jedisClusterNodes = new HashSet<HostAndPort>();
        jedisClusterNodes.addAll(this.parseHosts(clusterHosts));
        JedisCluster jedisCluster = new JedisCluster(jedisClusterNodes, connectionTimeout, (GenericObjectPoolConfig)PoolConverter.getJedisPoolConfig(this.poolConfigParams));
        logger.info(String.format("Redis connector ready, clusterHosts: %s, timeout: %d, pool config: %s", clusterHosts, connectionTimeout, ToStringBuilder.reflectionToString((Object)this.poolConfigParams, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE)));
        JedisClusteredConnection jedisClusteredConnection = new JedisClusteredConnection(this.configName, jedisCluster, this.objectSerializer, this.schedulerService, this.schedulerConfig);
        jedisClusteredConnection.start();
        return jedisClusteredConnection;
    }

    public void disconnect(RedisConnection conn) {
        conn.stop();
        conn.close();
    }

    private List<HostAndPort> parseHosts(String hosts) {
        ArrayList<HostAndPort> hostAndPorts = new ArrayList<HostAndPort>();
        for (String hostAndPort : hosts.split(",")) {
            String[] fields = hostAndPort.split(":");
            hostAndPorts.add(new HostAndPort(fields[0], Integer.parseInt(fields[1])));
        }
        return hostAndPorts;
    }

    public ConnectionValidationResult validate(RedisConnection conn) {
        try {
            conn.validate();
            return ConnectionValidationResult.success();
        }
        catch (Exception e) {
            return ConnectionValidationResult.failure((String)"Connection is no longer valid", (Exception)e);
        }
    }
}

