/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.redis.internal.service;

import java.util.function.Supplier;
import org.mule.extension.redis.internal.error.exceptions.InvalidDataException;
import org.mule.extension.redis.internal.error.exceptions.RedisConnectionException;
import org.mule.extension.redis.internal.error.exceptions.UnableToSendRequestException;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.exceptions.JedisException;

public abstract class BaseApiService {
    protected <T> T execute(Supplier<T> supplier) {
        try {
            return supplier.get();
        }
        catch (JedisDataException e) {
            throw new InvalidDataException("Invalid data sending to redis: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (JedisConnectionException e) {
            throw new RedisConnectionException("Something went wrong while connecting to redis: " + e.getMessage(), e);
        }
        catch (JedisException e) {
            throw new UnableToSendRequestException("Something went wrong while sending data to redis: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (IllegalArgumentException e) {
            throw new InvalidDataException("Invalid data sent to Redis: " + e.getMessage(), e);
        }
    }
}

