/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.redis.internal.service;

import java.util.Map;
import java.util.Set;
import org.mule.extension.redis.internal.connection.JedisClusteredConnection;
import org.mule.extension.redis.internal.error.exceptions.UnableToRetrieveResponseException;
import org.mule.extension.redis.internal.service.BaseApiService;
import org.mule.extension.redis.internal.service.RedisAPIService;
import org.mule.extension.redis.internal.utils.RedisUtils;
import redis.clients.jedis.JedisCluster;
import redis.clients.util.SafeEncoder;

public class ClusteredApiService
extends BaseApiService
implements RedisAPIService {
    private final JedisCluster cluster;

    public ClusteredApiService(JedisClusteredConnection connection) {
        this.cluster = connection.getJedisCluster();
    }

    @Override
    public Long setnx(String key, byte[] value) {
        return this.execute(() -> {
            byte[] encode = SafeEncoder.encode((String)key);
            Long response = this.cluster.setnx(encode, value);
            if (response != null) {
                return response;
            }
            throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
        });
    }

    @Override
    public String set(String key, String value, Integer entryTTL, boolean ifNotExists) {
        return this.execute(() -> {
            byte[] valueAsBytes = RedisUtils.toBytes(value, "UTF-8");
            String result = value;
            if (ifNotExists) {
                if (this.setnx(key, valueAsBytes) == 0L) {
                    result = null;
                }
            } else {
                result = this.cluster.set(SafeEncoder.encode((String)key), valueAsBytes);
            }
            if (entryTTL != null) {
                this.expire(key, entryTTL);
            }
            if (result != null) {
                return result;
            }
            throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
        });
    }

    @Override
    public byte[] set(String key, byte[] value, Integer entryTTL, boolean ifNotExists) {
        return this.execute(() -> {
            String result = null;
            if (ifNotExists) {
                if (this.setnx(key, value) == 0L) {
                    result = null;
                }
            } else {
                result = this.cluster.set(SafeEncoder.encode((String)key), value);
            }
            if (entryTTL != null) {
                this.expire(key, entryTTL);
            }
            if (result != null) {
                return result.getBytes();
            }
            throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
        });
    }

    @Override
    public Long expire(String key, int seconds) {
        return this.execute(() -> {
            Long response = this.cluster.expire(SafeEncoder.encode((String)key), seconds);
            if (response != null) {
                return response;
            }
            throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
        });
    }

    @Override
    public byte[] get(String key) {
        return this.execute(() -> {
            byte[] response = this.cluster.get(SafeEncoder.encode((String)key));
            return response;
        });
    }

    @Override
    public boolean exists(String key) {
        return this.execute(() -> {
            Boolean response = this.cluster.exists(SafeEncoder.encode((String)key));
            if (response != null) {
                return response;
            }
            throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
        });
    }

    @Override
    public Long incr(String key) {
        return this.execute(() -> {
            Long response = this.cluster.incr(SafeEncoder.encode((String)key));
            if (response != null) {
                return response;
            }
            throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
        });
    }

    @Override
    public Long incrBy(String key, long integer) {
        return this.execute(() -> {
            Long response = this.cluster.incrBy(SafeEncoder.encode((String)key), integer);
            if (response != null) {
                return response;
            }
            throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
        });
    }

    @Override
    public Long decr(String key) {
        return this.execute(() -> {
            Long response = this.cluster.decr(SafeEncoder.encode((String)key));
            if (response != null) {
                return response;
            }
            throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
        });
    }

    @Override
    public Long decrBy(String key, long integer) {
        return this.execute(() -> {
            Long response = this.cluster.decrBy(SafeEncoder.encode((String)key), integer);
            if (response != null) {
                return response;
            }
            throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
        });
    }

    @Override
    public Long hsetnx(String key, byte[] field, byte[] value) {
        return this.execute(() -> {
            Long response = this.cluster.hsetnx(SafeEncoder.encode((String)key), field, value);
            if (response != null) {
                return response;
            }
            throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
        });
    }

    @Override
    public Long hset(String key, String value, String field, boolean ifNotExists) {
        return this.execute(() -> {
            Long response = null;
            byte[] fieldAsBytes = SafeEncoder.encode((String)field);
            byte[] valueAsBytes = RedisUtils.toBytes(value, "UTF-8");
            if (ifNotExists) {
                if (this.hsetnx(key, fieldAsBytes, valueAsBytes) == 0L) {
                    return null;
                }
            } else {
                response = this.cluster.hset(SafeEncoder.encode((String)key), fieldAsBytes, valueAsBytes);
                if (response == null) {
                    throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
                }
            }
            return response;
        });
    }

    @Override
    public byte[] hget(String key, String field) {
        return this.execute(() -> this.cluster.hget(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field)));
    }

    @Override
    public Map<String, String> hgetAll(String key) {
        return this.execute(() -> {
            Map response = this.cluster.hgetAll(key);
            if (response != null) {
                return response;
            }
            throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
        });
    }

    @Override
    public Long hincrBy(String key, String field, long value) {
        return this.execute(() -> {
            Long response = this.cluster.hincrBy(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), value);
            if (response != null) {
                return response;
            }
            throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
        });
    }

    @Override
    public Set<byte[]> hkeys(String key) {
        return this.execute(() -> {
            Set response = this.cluster.hkeys(SafeEncoder.encode((String)key));
            if (response != null) {
                return response;
            }
            throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
        });
    }

    @Override
    public Set<byte[]> keys(String key) {
        return this.execute(() -> {
            Set response = this.cluster.hkeys(SafeEncoder.encode((String)key));
            if (response != null) {
                return response;
            }
            throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
        });
    }

    @Override
    public Long del(String ... keys) {
        return this.execute(() -> {
            Long response = this.cluster.del(keys);
            if (response != null) {
                return response;
            }
            throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
        });
    }

    @Override
    public byte[] rpop(String key) {
        return this.execute(() -> {
            byte[] response = this.cluster.rpop(SafeEncoder.encode((String)key));
            if (response != null) {
                return response;
            }
            throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
        });
    }

    @Override
    public Long lpushx(String key, String string) {
        return this.execute(() -> {
            Long response = this.cluster.lpushx(SafeEncoder.encode((String)key), (byte[][])new byte[][]{RedisUtils.toBytes(string, "UTF-8")});
            if (response != null) {
                return response;
            }
            throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
        });
    }

    @Override
    public Long lpush(String key, String string) {
        return this.execute(() -> {
            Long response = this.cluster.lpush(SafeEncoder.encode((String)key), (byte[][])new byte[][]{RedisUtils.toBytes(string, "UTF-8")});
            if (response != null) {
                return response;
            }
            throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
        });
    }

    @Override
    public Long sadd(String key, byte[] string) {
        return this.execute(() -> {
            Long response = this.cluster.sadd(SafeEncoder.encode((String)key), (byte[][])new byte[][]{string});
            if (response != null) {
                return response;
            }
            throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
        });
    }

    @Override
    public byte[] spop(String key) {
        return this.execute(() -> {
            byte[] response = this.cluster.spop(SafeEncoder.encode((String)key));
            if (response != null) {
                return response;
            }
            throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
        });
    }

    @Override
    public byte[] srandmember(String key) {
        return this.execute(() -> this.cluster.srandmember(SafeEncoder.encode((String)key)));
    }

    @Override
    public Long zadd(String key, double score, byte[] member) {
        return this.execute(() -> {
            Long response = this.cluster.zadd(SafeEncoder.encode((String)key), score, member);
            if (response != null) {
                return response;
            }
            throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
        });
    }

    @Override
    public byte[] lpop(String key) {
        return this.execute(() -> {
            byte[] response = this.cluster.lpop(SafeEncoder.encode((String)key));
            if (response != null) {
                return response;
            }
            throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
        });
    }

    @Override
    public Long rpushx(String key, String string) {
        return this.execute(() -> {
            Long response = this.cluster.rpushx(SafeEncoder.encode((String)key), (byte[][])new byte[][]{RedisUtils.toBytes(string, "UTF-8")});
            if (response != null) {
                return response;
            }
            throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
        });
    }

    @Override
    public Long rpush(String key, String string) {
        return this.execute(() -> {
            Long response = this.cluster.rpush(SafeEncoder.encode((String)key), (byte[][])new byte[][]{RedisUtils.toBytes(string, "UTF-8")});
            if (response != null) {
                return response;
            }
            throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
        });
    }

    @Override
    public Set<byte[]> zrange(String key, long start, long end) {
        return this.execute(() -> {
            Set response = this.cluster.zrange(SafeEncoder.encode((String)key), start, end);
            if (response != null) {
                return response;
            }
            throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
        });
    }

    @Override
    public Set<byte[]> zrangeByScore(String key, double min, double max) {
        return this.execute(() -> {
            Set response = this.cluster.zrangeByScore(SafeEncoder.encode((String)key), min, max);
            if (response != null) {
                return response;
            }
            throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
        });
    }

    @Override
    public Set<byte[]> zrevrange(String key, long start, long end) {
        return this.execute(() -> {
            Set response = this.cluster.zrevrange(SafeEncoder.encode((String)key), start, end);
            if (response != null) {
                return response;
            }
            throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
        });
    }

    @Override
    public Set<byte[]> zrevrangeByScore(String key, double max, double min) {
        return this.execute(() -> {
            Set response = this.cluster.zrevrangeByScore(SafeEncoder.encode((String)key), max, min);
            if (response != null) {
                return response;
            }
            throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
        });
    }

    @Override
    public Double zincrby(String key, double score, String member) {
        return this.execute(() -> {
            Double response = this.cluster.zincrby(SafeEncoder.encode((String)key), score, RedisUtils.toBytes(member, "UTF-8"));
            if (response != null) {
                return response;
            }
            throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
        });
    }

    @Override
    public Long expireAt(String key, long unixTime) {
        return this.execute(() -> {
            Long response = this.cluster.expireAt(SafeEncoder.encode((String)key), unixTime);
            if (response != null) {
                return response;
            }
            throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
        });
    }

    @Override
    public Long persist(String key) {
        return this.execute(() -> {
            Long response = this.cluster.persist(SafeEncoder.encode((String)key));
            if (response != null) {
                return response;
            }
            throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
        });
    }

    @Override
    public Long ttl(String key) {
        return this.execute(() -> {
            Long response = this.cluster.ttl(SafeEncoder.encode((String)key));
            if (response != null) {
                return response;
            }
            throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
        });
    }

    @Override
    public Long publish(String channel, String message) {
        return this.execute(() -> {
            Long response = this.cluster.publish(channel, message);
            if (response != null) {
                return response;
            }
            throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
        });
    }

    @Override
    public boolean hexists(String key, byte[] field) {
        return this.execute(() -> {
            Boolean response = this.cluster.hexists(SafeEncoder.encode((String)key), field);
            if (response != null) {
                return response;
            }
            throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
        });
    }
}

