/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.redis.internal.service;

import java.util.Map;
import java.util.Set;
import org.mule.extension.redis.internal.connection.JedisPoolConnection;
import org.mule.extension.redis.internal.error.exceptions.InvalidDataException;
import org.mule.extension.redis.internal.error.exceptions.RedisConnectionException;
import org.mule.extension.redis.internal.error.exceptions.UnableToCloseConnection;
import org.mule.extension.redis.internal.error.exceptions.UnableToRetrieveResponseException;
import org.mule.extension.redis.internal.error.exceptions.UnableToSendRequestException;
import org.mule.extension.redis.internal.service.BaseApiService;
import org.mule.extension.redis.internal.service.RedisAPIService;
import org.mule.extension.redis.internal.utils.RedisUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.util.SafeEncoder;

public class PooledApiService
extends BaseApiService
implements RedisAPIService {
    private static final Logger logger = LoggerFactory.getLogger(PooledApiService.class);
    private JedisPool jedisPool;

    public PooledApiService(JedisPoolConnection connection) {
        this.jedisPool = connection.getJedisPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long setnx(String key, byte[] value) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Long l = this.execute(() -> {
                Long response = jedis.setnx(SafeEncoder.encode((String)key), value);
                if (response != null) {
                    return response;
                }
                throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
            });
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String set(String key, String value, Integer entryTTL, boolean ifNotExists) {
        try (Jedis jedis = this.jedisPool.getResource();){
            String string = this.execute(() -> {
                byte[] valueAsBytes = RedisUtils.toBytes(value, "UTF-8");
                String result = value;
                if (ifNotExists) {
                    if (this.setnx(key, valueAsBytes) == 0L) {
                        result = null;
                    }
                } else {
                    result = jedis.set(SafeEncoder.encode((String)key), valueAsBytes);
                }
                if (entryTTL != null) {
                    this.expire(key, entryTTL);
                }
                if (result != null) {
                    return result;
                }
                throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
            });
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] set(String key, byte[] value, Integer entryTTL, boolean ifNotExists) throws InvalidDataException, RedisConnectionException, UnableToSendRequestException, UnableToRetrieveResponseException {
        try (Jedis jedis = this.jedisPool.getResource();){
            byte[] byArray = this.execute(() -> {
                String result = null;
                if (ifNotExists) {
                    if (this.setnx(key, value) == 0L) {
                        result = null;
                    }
                } else {
                    result = jedis.set(SafeEncoder.encode((String)key), value);
                }
                if (entryTTL != null) {
                    this.expire(key, entryTTL);
                }
                if (result != null) {
                    return result.getBytes();
                }
                throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
            });
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long expire(String key, int seconds) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Long l = this.execute(() -> {
                Long response = jedis.expire(SafeEncoder.encode((String)key), seconds);
                if (response != null) {
                    return response;
                }
                throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
            });
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] get(String key) {
        try (Jedis jedis = this.jedisPool.getResource();){
            byte[] byArray = this.execute(() -> {
                byte[] response = jedis.get(SafeEncoder.encode((String)key));
                return response;
            });
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String key) {
        try (Jedis jedis = this.jedisPool.getResource();){
            boolean bl = this.execute(() -> {
                Boolean response = jedis.exists(SafeEncoder.encode((String)key));
                if (response != null) {
                    return response;
                }
                throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
            });
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long incr(String key) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Long l = this.execute(() -> {
                Long response = jedis.incr(SafeEncoder.encode((String)key));
                if (response != null) {
                    return response;
                }
                throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
            });
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long incrBy(String key, long integer) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Long l = this.execute(() -> {
                Long response = jedis.incrBy(SafeEncoder.encode((String)key), integer);
                if (response != null) {
                    return response;
                }
                throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
            });
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long decr(String key) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Long l = this.execute(() -> {
                Long response = jedis.decr(SafeEncoder.encode((String)key));
                if (response != null) {
                    return response;
                }
                throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
            });
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long decrBy(String key, long integer) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Long l = this.execute(() -> {
                Long response = jedis.decrBy(SafeEncoder.encode((String)key), integer);
                if (response != null) {
                    return response;
                }
                throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
            });
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long hsetnx(String key, byte[] field, byte[] value) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Long l = this.execute(() -> {
                Long response = jedis.hsetnx(SafeEncoder.encode((String)key), field, value);
                if (response != null) {
                    return response;
                }
                throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
            });
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long hset(String key, String value, String field, boolean ifNotExists) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Long l = this.execute(() -> {
                Long response = null;
                byte[] fieldAsBytes = SafeEncoder.encode((String)field);
                byte[] valueAsBytes = RedisUtils.toBytes(value, "UTF-8");
                if (ifNotExists) {
                    if (this.hsetnx(key, fieldAsBytes, valueAsBytes) == 0L) {
                        return null;
                    }
                } else {
                    response = jedis.hset(SafeEncoder.encode((String)key), fieldAsBytes, valueAsBytes);
                    if (response == null) {
                        throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
                    }
                }
                return response;
            });
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] hget(String key, String field) {
        try (Jedis jedis = this.jedisPool.getResource();){
            byte[] byArray = this.execute(() -> jedis.hget(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field)));
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> hgetAll(String key) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Map map = this.execute(() -> {
                Map response = jedis.hgetAll(key);
                if (response != null) {
                    return response;
                }
                throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
            });
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long hincrBy(String key, String field, long value) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Long l = this.execute(() -> {
                Long response = jedis.hincrBy(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), value);
                if (response != null) {
                    return response;
                }
                throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
            });
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<byte[]> hkeys(String key) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Set set = this.execute(() -> {
                Set response = jedis.hkeys(SafeEncoder.encode((String)key));
                if (response != null) {
                    return response;
                }
                throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
            });
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<byte[]> keys(String key) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Set set = this.execute(() -> {
                Set response = jedis.keys(SafeEncoder.encode((String)key));
                if (response != null) {
                    return response;
                }
                throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
            });
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long del(String ... keys) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Long l = this.execute(() -> {
                Long response = jedis.del(keys);
                if (response != null) {
                    return response;
                }
                throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
            });
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] rpop(String key) {
        try (Jedis jedis = this.jedisPool.getResource();){
            byte[] byArray = this.execute(() -> {
                byte[] response = jedis.rpop(SafeEncoder.encode((String)key));
                if (response != null) {
                    return response;
                }
                throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
            });
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long lpushx(String key, String string) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Long l = this.execute(() -> {
                Long response = jedis.lpushx(SafeEncoder.encode((String)key), (byte[][])new byte[][]{RedisUtils.toBytes(string, "UTF-8")});
                if (response != null) {
                    return response;
                }
                throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
            });
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long lpush(String key, String string) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Long l = this.execute(() -> {
                Long response = jedis.lpush(SafeEncoder.encode((String)key), (byte[][])new byte[][]{RedisUtils.toBytes(string, "UTF-8")});
                if (response != null) {
                    return response;
                }
                throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
            });
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long sadd(String key, byte[] string) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Long l = this.execute(() -> {
                Long response = jedis.sadd(SafeEncoder.encode((String)key), (byte[][])new byte[][]{string});
                if (response != null) {
                    return response;
                }
                throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
            });
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] spop(String key) {
        try (Jedis jedis = this.jedisPool.getResource();){
            byte[] byArray = this.execute(() -> {
                byte[] response = jedis.spop(SafeEncoder.encode((String)key));
                if (response != null) {
                    return response;
                }
                throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
            });
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] srandmember(String key) {
        try (Jedis jedis = this.jedisPool.getResource();){
            byte[] byArray = this.execute(() -> jedis.srandmember(SafeEncoder.encode((String)key)));
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zadd(String key, double score, byte[] member) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Long l = this.execute(() -> {
                Long response = jedis.zadd(SafeEncoder.encode((String)key), score, member);
                if (response != null) {
                    return response;
                }
                throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
            });
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] lpop(String key) {
        try (Jedis jedis = this.jedisPool.getResource();){
            byte[] byArray = this.execute(() -> {
                byte[] response = jedis.lpop(SafeEncoder.encode((String)key));
                if (response != null) {
                    return response;
                }
                throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
            });
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long rpushx(String key, String string) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Long l = this.execute(() -> {
                Long response = jedis.rpushx(SafeEncoder.encode((String)key), (byte[][])new byte[][]{RedisUtils.toBytes(string, "UTF-8")});
                if (response != null) {
                    return response;
                }
                throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
            });
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long rpush(String key, String string) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Long l = this.execute(() -> {
                Long response = jedis.rpush(SafeEncoder.encode((String)key), (byte[][])new byte[][]{RedisUtils.toBytes(string, "UTF-8")});
                if (response != null) {
                    return response;
                }
                throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
            });
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<byte[]> zrange(String key, long start, long end) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Set set = this.execute(() -> {
                Set response = jedis.zrange(SafeEncoder.encode((String)key), start, end);
                if (response != null) {
                    return response;
                }
                throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
            });
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<byte[]> zrangeByScore(String key, double min, double max) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Set set = this.execute(() -> {
                Set response = jedis.zrangeByScore(SafeEncoder.encode((String)key), min, max);
                if (response != null) {
                    return response;
                }
                throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
            });
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<byte[]> zrevrange(String key, long start, long end) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Set set = this.execute(() -> {
                Set response = jedis.zrevrange(SafeEncoder.encode((String)key), start, end);
                if (response != null) {
                    return response;
                }
                throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
            });
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<byte[]> zrevrangeByScore(String key, double max, double min) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Set set = this.execute(() -> {
                Set response = jedis.zrevrangeByScore(SafeEncoder.encode((String)key), max, min);
                if (response != null) {
                    return response;
                }
                throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
            });
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double zincrby(String key, double score, String member) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Double d = this.execute(() -> {
                Double response = jedis.zincrby(SafeEncoder.encode((String)key), score, RedisUtils.toBytes(member, "UTF-8"));
                if (response != null) {
                    return response;
                }
                throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
            });
            return d;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long expireAt(String key, long unixTime) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Long l = this.execute(() -> {
                Long response = jedis.expireAt(SafeEncoder.encode((String)key), unixTime);
                if (response != null) {
                    return response;
                }
                throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
            });
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long persist(String key) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Long l = this.execute(() -> {
                Long response = jedis.persist(SafeEncoder.encode((String)key));
                if (response != null) {
                    return response;
                }
                throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
            });
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long ttl(String key) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Long l = this.execute(() -> {
                Long response = jedis.ttl(SafeEncoder.encode((String)key));
                if (response != null) {
                    return response;
                }
                throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
            });
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long publish(String channel, String message) {
        Jedis jedis = this.jedisPool.getResource();
        try {
            Long l = this.execute(() -> {
                Long response = jedis.publish(channel, message);
                if (response != null) {
                    return response;
                }
                throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
            });
            return l;
        }
        finally {
            if (jedis != null) {
                this.terminateJedisClient(jedis);
            }
        }
    }

    private void terminateJedisClient(Jedis jedis) {
        try {
            logger.debug("Closing jedis connection");
            jedis.close();
        }
        catch (JedisConnectionException e) {
            throw new UnableToCloseConnection("Unable to close connection with server.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hexists(String key, byte[] field) {
        try (Jedis jedis = this.jedisPool.getResource();){
            boolean bl = this.execute(() -> {
                Boolean response = jedis.hexists(SafeEncoder.encode((String)key), field);
                if (response != null) {
                    return response;
                }
                throw new UnableToRetrieveResponseException("Something went wrong while retrieving results from redis");
            });
            return bl;
        }
    }
}

