/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.redis.internal.service.cluster;

import java.util.Objects;
import org.mule.extension.redis.internal.service.RedisClientAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.BinaryJedisPubSub;
import redis.clients.jedis.JedisCluster;

public class ClusteredClientAdapter
implements RedisClientAdapter {
    private static final Logger logger = LoggerFactory.getLogger(ClusteredClientAdapter.class);
    private JedisCluster jedisCluster;

    public ClusteredClientAdapter(JedisCluster jedisCluster) {
        Objects.requireNonNull(jedisCluster, "JeidsCluster client cannot be null.");
        this.jedisCluster = jedisCluster;
    }

    @Override
    public void psubscribe(BinaryJedisPubSub jedisPubSub, byte[][] patterns) {
        logger.debug("Calling \"psubscribe\" on client.");
        this.jedisCluster.psubscribe(jedisPubSub, patterns);
    }

    @Override
    public void close() {
        logger.debug("No action has to be taken by adapter.");
    }
}

