/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.rosettanet.extension.internal;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

public final class Utility {
    public static final Charset CHARSET_UTF8 = Charset.forName("UTF-8");

    private Utility() {
    }

    public static byte[] readFully(InputStream is) throws IOException {
        int actual;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        while ((actual = is.read(data)) > 0) {
            os.write(data, 0, actual);
        }
        return os.toByteArray();
    }

    public static String directoryPath(String path) {
        int split = path.lastIndexOf(47);
        if (split < 0) {
            throw new IllegalArgumentException("Base path " + path + " doesn't have a directory");
        }
        return path.substring(0, split + 1);
    }

    public static InputStream findResource(String path) {
        try {
            File file = new File(path);
            if (file.exists()) {
                return new FileInputStream(file);
            }
            InputStream is = Utility.class.getResourceAsStream(path);
            if (is == null) {
                String relpath = path;
                if (relpath.startsWith("/")) {
                    relpath = relpath.substring(1);
                }
                if ((is = Utility.class.getClassLoader().getResourceAsStream(relpath)) == null) {
                    is = Thread.currentThread().getContextClassLoader().getResourceAsStream(relpath);
                }
            }
            return is;
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading resource " + path, e);
        }
    }

    public static String concatenateOptional(String a, String b) {
        if (b == null || b.isEmpty()) {
            return a;
        }
        return a + ":" + b;
    }
}

