/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.rosettanet.extension.internal.config;

import com.mulesoft.connectors.rosettanet.extension.internal.Utility;
import com.mulesoft.connectors.rosettanet.extension.internal.config.pip.ActionDetail;
import com.mulesoft.connectors.rosettanet.extension.internal.exception.ConfigurationException;
import java.io.IOException;
import java.io.InputStream;

public final class DtdHandling {
    private static final String START_REF = "%";
    private static final String END_REF = ";";

    private DtdHandling() {
    }

    private static String rootElementOfDtd(String path, String dtd) {
        String[] tokens = dtd.trim().split("\\s+");
        int state = 0;
        block5: for (int index = 0; index < tokens.length; ++index) {
            String token = tokens[index];
            switch (state) {
                case 0: {
                    if ("<!ELEMENT".equals(token)) {
                        state = 1;
                        continue block5;
                    }
                    if (!"<!--".equals(token)) continue block5;
                    state = 2;
                    continue block5;
                }
                case 1: {
                    return DtdHandling.replaceReferences(tokens, token);
                }
                case 2: {
                    if (!"-->".equals(token)) continue block5;
                    state = 0;
                }
            }
        }
        throw new ConfigurationException("Unable to parse DTD at [" + path + "] to find first element");
    }

    private static String replaceReferences(String[] tokens, String firstElement) {
        if (!firstElement.contains(START_REF)) {
            return firstElement;
        }
        for (int index = 0; index < tokens.length; ++index) {
            String token = tokens[index];
            if (!"<!ENTITY".equals(token)) continue;
            String key = START_REF + tokens[index + 2] + END_REF;
            String value = tokens[index + 3].replaceAll("\">", "").replaceAll("\"", "");
            if (!firstElement.contains(key)) continue;
            return DtdHandling.replaceReferences(tokens, firstElement.replace(key, value));
        }
        throw new ConfigurationException("Unable to find references parsing DTD at [ " + firstElement + " ]");
    }

    public static String getActionRootElement(String pipPath, ActionDetail action) {
        String dtd;
        String dtdPath = Utility.directoryPath(pipPath) + action.getDtdName();
        InputStream dtdStream = Utility.findResource(dtdPath);
        if (dtdStream == null) {
            throw new IllegalArgumentException("DTD not found at [" + dtdPath + "] (base path [" + pipPath + "] and action [" + action.getActionCode() + "])");
        }
        try {
            byte[] data = Utility.readFully(dtdStream);
            dtd = new String(data, "UTF-8");
        }
        catch (IOException e) {
            throw new ConfigurationException("Unable to read DTD at [" + dtdPath + "]", (Throwable)e);
        }
        return DtdHandling.rootElementOfDtd(dtdPath, dtd);
    }
}

