/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.rosettanet.extension.internal.config;

import com.mulesoft.connectors.rosettanet.extension.internal.Utility;
import com.mulesoft.connectors.rosettanet.extension.internal.config.pip.PipDetail;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public final class PipLoader {
    private static final Logger logger = LoggerFactory.getLogger(PipLoader.class);
    public static final String SCHEMA_PATH = "/schemas/pip-detail.xsd";

    private PipLoader() {
    }

    public static PipDetail loadPip(String path) throws JAXBException, SAXException {
        JAXBContext jc = JAXBContext.newInstance((String)PipDetail.class.getPackage().getName());
        Unmarshaller u = jc.createUnmarshaller();
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = sf.newSchema(new StreamSource(Utility.findResource(SCHEMA_PATH)));
        u.setSchema(schema);
        InputStream pipis = Utility.findResource(path);
        if (pipis == null) {
            String text = "Could not access PIP configuration " + path;
            logger.error(text);
            throw new RuntimeException(text);
        }
        JAXBElement root = (JAXBElement)u.unmarshal(pipis);
        return (PipDetail)root.getValue();
    }
}

