/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.rosettanet.extension.internal.config;

import com.mulesoft.b2b.sync.SyncSingleton;
import com.mulesoft.b2b.sync.config.ObjectStoreFactoryFromManager;
import com.mulesoft.b2b.sync.config.SyncConfigurationProvided;
import com.mulesoft.b2b.sync.provider.ObjectStoreWithLockManager;
import com.mulesoft.connectors.rosettanet.extension.api.config.ForceSigning;
import com.mulesoft.connectors.rosettanet.extension.api.config.PipRole;
import com.mulesoft.connectors.rosettanet.extension.api.config.UsageCode;
import com.mulesoft.connectors.rosettanet.extension.crypto.signature.SigningAlgorithm;
import com.mulesoft.connectors.rosettanet.extension.internal.Utility;
import com.mulesoft.connectors.rosettanet.extension.internal.config.DtdHandling;
import com.mulesoft.connectors.rosettanet.extension.internal.config.PipLoader;
import com.mulesoft.connectors.rosettanet.extension.internal.config.RosettaObjectStoreManager;
import com.mulesoft.connectors.rosettanet.extension.internal.config.pip.ActionDetail;
import com.mulesoft.connectors.rosettanet.extension.internal.config.pip.PipDetail;
import com.mulesoft.connectors.rosettanet.extension.internal.delivery.DeliveryManager;
import com.mulesoft.connectors.rosettanet.extension.internal.exception.ConfigurationException;
import com.mulesoft.connectors.rosettanet.extension.internal.listener.ListenerManager;
import com.mulesoft.connectors.rosettanet.extension.internal.operation.RosettaNetOperations;
import com.mulesoft.connectors.rosettanet.extension.internal.rnif.MimeMessageBuilder;
import com.mulesoft.connectors.rosettanet.extension.internal.source.ActionSource;
import com.mulesoft.connectors.rosettanet.extension.internal.source.CompletionSource;
import java.io.Serializable;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.display.PathModel;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.Sources;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Password;
import org.mule.runtime.extension.api.annotation.param.display.Path;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.reference.ConfigReference;
import org.mule.runtime.extension.api.annotation.param.reference.ObjectStoreReference;
import org.mule.runtime.extension.api.client.ExtensionsClient;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.server.HttpServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Operations(value={RosettaNetOperations.class})
@Configuration(name="config")
@Sources(value={ActionSource.class, CompletionSource.class})
public class RosettaNetConfig
implements Initialisable,
Startable,
Stoppable {
    private static final Logger logger = LoggerFactory.getLogger(RosettaNetConfig.class);
    @ConfigReference(namespace="HTTP", name="LISTENER_CONFIG")
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Global HTTP Listener")
    @Placement(order=1)
    private String listenerConfigName;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Service Endpoint Path")
    @Placement(order=2)
    private String servicePath;
    @ConfigReference(namespace="HTTP", name="REQUEST_CONFIG")
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Global HTTP Request")
    @Placement(order=3)
    private String requesterConfigName;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Request Endpoint Path")
    @Placement(order=4)
    private String requestPath;
    @Parameter
    @Optional(defaultValue="false")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Require secure transport (HTTPS)")
    @Placement(order=5)
    private boolean requireSecureTransport;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Path(type=PathModel.Type.FILE)
    @DisplayName(value="Keystore path")
    @Placement(order=6)
    private String keystorePath;
    @Parameter
    @Optional
    @DisplayName(value="Keystore access password")
    @Password
    @Placement(order=7)
    private String keystorePass;
    @Parameter
    @Optional
    @DisplayName(value="Signing key password")
    @Placement(order=8)
    @Password
    private String privatePass;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Override message signing")
    @Placement(order=9)
    private ForceSigning signingOverride;
    @Parameter
    @Optional(defaultValue="SHA1")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Signing algorithm")
    @Placement(order=10)
    private SigningAlgorithm signingAlgorithm;
    @Parameter
    @Optional(defaultValue="Production")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Global usage code")
    @Placement(order=11)
    private UsageCode globalUsageCode;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Object store reference")
    @ObjectStoreReference
    @Placement(order=12)
    private ObjectStore<? extends Serializable> objectStore;
    @Parameter
    @DisplayName(value="Mule DUNS identifier")
    @Placement(order=13)
    private String selfBusinessIdentifier;
    @Parameter
    @Optional
    @DisplayName(value="Mule location identifier")
    @Placement(order=14)
    private String selfLocationId;
    @Parameter
    @DisplayName(value="Partner DUNS identifier")
    @Placement(order=15)
    private String partnerBusinessIdentifier;
    @Parameter
    @Optional
    @DisplayName(value="Partner location identifier")
    @Placement(order=16)
    private String partnerLocationId;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Role in PIP")
    @Placement(order=17)
    private PipRole pipRole;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="PIP definition path")
    @Placement(order=18)
    private String pipFile;
    @RefName
    private String configName;
    @Inject
    private LockFactory lockFactory;
    @Inject
    private ObjectStoreManager objectStoreManager;
    @Inject
    private HttpService httpService;
    private HttpServer httpServer;
    @Inject
    private ExtensionsClient extClient;
    @Inject
    private SchedulerService schedulerService;
    @Inject
    private SchedulerConfig schedulerConfig;
    @Inject
    private DeliveryManager deliveryManager;
    @Inject
    private ListenerManager listenerManager;
    private Scheduler sendExecutor;
    private PipDetail pipDetail;
    private String initiatorActionRoot;
    private String responderActionRoot;
    private MimeMessageBuilder messageBuilder;
    private ObjectStoreWithLockManager osManager;
    private static final String DEFAULT_OBJECT_STORE = "RosettaNetObjectStore";
    private static final int MESSAGES_PERSIST_DAYS = 3;

    public void initialise() throws InitialisationException {
        if (this.requesterConfigName == null) {
            throw new ConfigurationException("Missing required HTTP requester reference");
        }
        if (this.listenerConfigName == null) {
            throw new ConfigurationException("Missing required HTTP listener reference");
        }
        this.sendExecutor = this.schedulerService.ioScheduler();
        PipDetail pip = this.getPipDetail();
        ActionDetail action = pip.getInitiatorAction();
        if (action != null) {
            this.initiatorActionRoot = DtdHandling.getActionRootElement(this.getPipFile(), action);
        }
        if ((action = pip.getResponderAction()) != null) {
            this.responderActionRoot = DtdHandling.getActionRootElement(this.getPipFile(), action);
        }
        if (this.getPrivatePass() == null) {
            this.messageBuilder = new MimeMessageBuilder();
        } else {
            if (this.getKeystorePath() == null || this.getKeystorePass() == null) {
                throw new IllegalArgumentException("Incomplete keystore configuration in RosettaNet configuration [" + this.getConfigName());
            }
            String alias = Utility.concatenateOptional(this.getSelfBusinessIdentifier(), this.getSelfLocationId());
            this.messageBuilder = new MimeMessageBuilder(this.getKeystorePath(), this.getKeystorePass(), this.getPrivatePass(), alias);
        }
        this.initOSManager();
    }

    private void initOSManager() {
        Scheduler scheduler = this.schedulerService.customScheduler(this.schedulerConfig.withMaxConcurrentTasks(3).withName("vm-listener-flow-rosetta").withWaitAllowed(true).withShutdownTimeout(10L, TimeUnit.SECONDS));
        ObjectStoreManager osManager = this.objectStoreManager;
        if (this.objectStore != null) {
            osManager = new RosettaObjectStoreManager(this.objectStore);
        }
        ObjectStoreFactoryFromManager osffm = new ObjectStoreFactoryFromManager(osManager, DEFAULT_OBJECT_STORE, Integer.valueOf(3));
        SyncConfigurationProvided sync = new SyncConfigurationProvided(DEFAULT_OBJECT_STORE).withScheduler(scheduler).withLockFactory(this.lockFactory).withObjectStore(osffm.createObjectStore());
        this.osManager = SyncSingleton.getInstance((SyncConfigurationProvided)sync).getKeyManager();
    }

    public void start() throws MuleException {
        if (this.objectStore != null && this.objectStore instanceof Startable) {
            ((Startable)this.objectStore).start();
        }
        this.httpServer = this.httpService.getServerFactory().lookup(this.listenerConfigName);
        this.listenerManager.registerSignal(this);
        this.deliveryManager.registerConfiguration(this);
    }

    public void stop() throws MuleException {
        this.listenerManager.unregisterSignal(this);
        this.deliveryManager.unregisterConfiguration(this);
        this.sendExecutor.stop();
        this.httpServer.stop();
    }

    public PipDetail getPipDetail() {
        if (this.pipDetail == null) {
            String file = this.getPipFile();
            if (file == null) {
                throw new RuntimeException("Missing PIP configuration required for operation");
            }
            try {
                this.pipDetail = PipLoader.loadPip(file);
            }
            catch (Exception e) {
                String text = "Error loading PIP information for " + this.getPipFile();
                logger.error(text, (Throwable)e);
                throw new RuntimeException(text, e);
            }
            if (this.pipDetail == null) {
                String text = "No PIP data found for " + this.getPipFile();
                logger.error(text);
                throw new RuntimeException(text);
            }
        }
        return this.pipDetail;
    }

    public ActionDetail getSendAction() {
        PipDetail detail = this.getPipDetail();
        if (this.getPipRole() == PipRole.INITIATOR) {
            return detail.getInitiatorAction();
        }
        return detail.getResponderAction();
    }

    public ActionDetail getReceiveAction() {
        PipDetail detail = this.getPipDetail();
        if (this.getPipRole() == PipRole.INITIATOR) {
            return detail.getResponderAction();
        }
        return detail.getInitiatorAction();
    }

    public String getSendRoot() {
        if (this.getPipRole() == PipRole.INITIATOR) {
            return this.initiatorActionRoot;
        }
        return this.responderActionRoot;
    }

    public String getReceiveRoot() {
        if (this.getPipRole() == PipRole.INITIATOR) {
            return this.responderActionRoot;
        }
        return this.initiatorActionRoot;
    }

    public String getListenerConfigName() {
        return this.listenerConfigName;
    }

    public void setListenerConfigName(String listenerConfigName) {
        this.listenerConfigName = listenerConfigName;
    }

    public String getServicePath() {
        return this.servicePath;
    }

    public void setServicePath(String servicePath) {
        this.servicePath = servicePath;
    }

    public String getRequesterConfigName() {
        return this.requesterConfigName;
    }

    public void setRequesterConfigName(String requesterConfigName) {
        this.requesterConfigName = requesterConfigName;
    }

    public String getRequestPath() {
        return this.requestPath;
    }

    public void setRequestPath(String requestPath) {
        this.requestPath = requestPath;
    }

    public String getKeystorePath() {
        return this.keystorePath;
    }

    public void setKeystorePath(String keystorePath) {
        this.keystorePath = keystorePath;
    }

    public String getKeystorePass() {
        return this.keystorePass;
    }

    public void setKeystorePass(String keystorePass) {
        this.keystorePass = keystorePass;
    }

    public String getPrivatePass() {
        return this.privatePass;
    }

    public void setPrivatePass(String privatePass) {
        this.privatePass = privatePass;
    }

    public ForceSigning getSigningOverride() {
        return this.signingOverride;
    }

    public SigningAlgorithm getSigningAlgorithm() {
        return this.signingAlgorithm;
    }

    public UsageCode getGlobalUsageCode() {
        return this.globalUsageCode;
    }

    public void setGlobalUsageCode(UsageCode globalUsageCode) {
        this.globalUsageCode = globalUsageCode;
    }

    public String getSelfBusinessIdentifier() {
        return this.selfBusinessIdentifier;
    }

    public boolean getRequireSecureTransport() {
        return this.requireSecureTransport;
    }

    public void setSelfBusinessIdentifier(String selfBusinessIdentifier) {
        this.selfBusinessIdentifier = selfBusinessIdentifier;
    }

    public String getSelfLocationId() {
        return this.selfLocationId;
    }

    public void setSelfLocationId(String selfLocationId) {
        this.selfLocationId = selfLocationId;
    }

    public String getPartnerBusinessIdentifier() {
        return this.partnerBusinessIdentifier;
    }

    public void setPartnerBusinessIdentifier(String partnerBusinessIdentifier) {
        this.partnerBusinessIdentifier = partnerBusinessIdentifier;
    }

    public String getPartnerLocationId() {
        return this.partnerLocationId;
    }

    public void setPartnerLocationId(String partnerLocationId) {
        this.partnerLocationId = partnerLocationId;
    }

    public PipRole getPipRole() {
        return this.pipRole;
    }

    public void setPipRole(PipRole pipRole) {
        this.pipRole = pipRole;
    }

    public String getPipFile() {
        return this.pipFile;
    }

    public void setPipFile(String pipFile) {
        this.pipFile = pipFile;
    }

    public HttpServer getHttpServer() {
        return this.httpServer;
    }

    public ExtensionsClient getExtClient() {
        return this.extClient;
    }

    public DeliveryManager getDeliveryManager() {
        return this.deliveryManager;
    }

    public ListenerManager getListenerManager() {
        return this.listenerManager;
    }

    public Executor getSendExecutor() {
        return this.sendExecutor;
    }

    public MimeMessageBuilder getMessageBuilder() {
        return this.messageBuilder;
    }

    public String getConfigName() {
        return this.configName;
    }

    public ObjectStoreWithLockManager getOsManager() {
        return this.osManager;
    }
}

