/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.rosettanet.extension.internal.delivery;

import com.mulesoft.b2b.sync.provider.ObjectStoreWithLockManager;
import com.mulesoft.connectors.rosettanet.extension.api.MessageAttributes;
import com.mulesoft.connectors.rosettanet.extension.api.data.Completion;
import com.mulesoft.connectors.rosettanet.extension.internal.MimeData;
import com.mulesoft.connectors.rosettanet.extension.internal.Utility;
import com.mulesoft.connectors.rosettanet.extension.internal.config.RosettaNetConfig;
import com.mulesoft.connectors.rosettanet.extension.internal.config.pip.PipDetail;
import com.mulesoft.connectors.rosettanet.extension.internal.delivery.StoreHandler;
import com.mulesoft.connectors.rosettanet.extension.internal.delivery.data.MessageDetail;
import java.util.IdentityHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeliveryManager {
    private static final Logger logger = LoggerFactory.getLogger(DeliveryManager.class);
    private final IdentityHashMap<ObjectStoreWithLockManager, StoreHandler> storeHandlers = new IdentityHashMap();
    private final ConcurrentHashMap<String, StoreHandler> configHandlers = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConfiguration(RosettaNetConfig config) {
        String name = config.getConfigName();
        StoreHandler handler = this.configHandlers.get(name);
        if (handler == null) {
            IdentityHashMap<ObjectStoreWithLockManager, StoreHandler> identityHashMap = this.storeHandlers;
            synchronized (identityHashMap) {
                handler = this.storeHandlers.computeIfAbsent(config.getOsManager(), o -> new StoreHandler((ObjectStoreWithLockManager)o, config.getSendExecutor()));
                handler.start();
            }
            handler.registerConfiguration(config);
            this.configHandlers.put(name, handler);
            if (logger.isDebugEnabled()) {
                PipDetail pipDetail = config.getPipDetail();
                String pipkey = pipDetail.getPipCode() + pipDetail.getPipVersion();
                String alias = Utility.concatenateOptional(config.getPartnerBusinessIdentifier(), config.getPartnerLocationId());
                logger.debug("Added action handling for PIP [" + pipkey + "] with partner [" + alias + "] to Delivery Manager for configuration [" + config.getConfigName() + "]");
            }
        } else {
            logger.error("Configuration [" + name + "] already registered");
        }
    }

    public void unregisterConfiguration(RosettaNetConfig config) {
        String name = config.getConfigName();
        StoreHandler handler = this.configHandlers.get(name);
        if (handler != null && handler.unregisterConfiguration(config) == 0) {
            handler.stop();
        }
    }

    public void registerCompletion(RosettaNetConfig config, SourceCallback<Completion, MessageAttributes> callback) {
        String name = config.getConfigName();
        StoreHandler handler = this.configHandlers.get(name);
        if (handler == null) {
            throw new IllegalArgumentException("Configuration [" + name + "] not registered");
        }
        handler.registerCompletion(config, callback);
    }

    public void unregisterCompletion(RosettaNetConfig config) {
        String name = config.getConfigName();
        StoreHandler handler = this.configHandlers.get(name);
        if (handler != null) {
            handler.unregisterCompletion(config);
        }
    }

    private StoreHandler getHandler(RosettaNetConfig config) {
        StoreHandler handler = this.configHandlers.get(config.getConfigName());
        if (handler == null) {
            throw new RuntimeException("No object store handler registered for configuration [" + config.getConfigName() + "]");
        }
        return handler;
    }

    public void sendAction(MimeData data, String msgId, RosettaNetConfig config) {
        StoreHandler handler = this.getHandler(config);
        PipDetail pip = config.getPipDetail();
        MessageDetail message = new MessageDetail();
        message.setMessageId(msgId);
        message.setPipCode(pip.getPipCode());
        message.setPipVersion(pip.getPipVersion());
        message.setMimeData(data);
        handler.initialSendAction(message, config);
    }

    public void handleCompletion(Completion complete, MessageAttributes attrs, RosettaNetConfig config) {
        logger.debug("Handling completion of message " + attrs.getMessageId());
        StoreHandler handler = this.getHandler(config);
        handler.completeMessage(config.getConfigName(), attrs, complete);
    }
}

