/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.rosettanet.extension.internal.listener;

import com.mulesoft.connectors.rosettanet.extension.api.MessageAttributes;
import com.mulesoft.connectors.rosettanet.extension.internal.config.RosettaNetConfig;
import com.mulesoft.connectors.rosettanet.extension.internal.listener.RosettaRequestHandler;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.runtime.http.api.server.ServerAddress;

public class ListenerManager {
    private final Map<ServerAddress, Map<String, RosettaRequestHandler>> refListeners;
    private Map<RosettaNetConfig, SourceCallback<InputStream, MessageAttributes>> callbacks = new HashMap<RosettaNetConfig, SourceCallback<InputStream, MessageAttributes>>();

    public ListenerManager() {
        this.refListeners = new ConcurrentHashMap<ServerAddress, Map<String, RosettaRequestHandler>>();
    }

    public void registerActionSource(RosettaNetConfig config, SourceCallback<InputStream, MessageAttributes> callback) {
        HttpServer server = config.getHttpServer();
        ServerAddress address = server.getServerAddress();
        String path = config.getServicePath();
        Map addressMap = this.refListeners.computeIfAbsent(address, a -> new ConcurrentHashMap());
        addressMap.computeIfAbsent(path, p -> {
            RosettaRequestHandler handler = new RosettaRequestHandler(config.getConfigName(), config.getDeliveryManager());
            server.addRequestHandler(path, (RequestHandler)handler);
            return handler;
        }).addUsage(config, callback);
        this.callbacks.put(config, callback);
    }

    public void registerSignal(RosettaNetConfig config) {
        HttpServer server = config.getHttpServer();
        ServerAddress address = server.getServerAddress();
        String path = config.getServicePath();
        Map addressMap = this.refListeners.computeIfAbsent(address, a -> new ConcurrentHashMap());
        addressMap.computeIfAbsent(path, p -> {
            RosettaRequestHandler handler = new RosettaRequestHandler(config.getConfigName(), config.getDeliveryManager());
            server.addRequestHandler(path, (RequestHandler)handler);
            return handler;
        }).addUsage(config, null);
    }

    public void unregisterActionSource(RosettaNetConfig config) {
        this.callbacks.remove(config);
        this.completeUnregister(config, true);
    }

    private void completeUnregister(RosettaNetConfig config, boolean action) {
        RosettaRequestHandler handler;
        HttpServer server = config.getHttpServer();
        Map<String, RosettaRequestHandler> addressMap = this.refListeners.get(server.getServerAddress());
        if (addressMap != null && (handler = addressMap.get(config.getServicePath())) != null) {
            handler.removeUsage(config, action);
        }
    }

    public void unregisterSignal(RosettaNetConfig config) {
        this.completeUnregister(config, false);
    }
}

