/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.rosettanet.extension.internal.listener;

import com.mulesoft.connectors.rosettanet.extension.api.MessageAttributes;
import com.mulesoft.connectors.rosettanet.extension.api.ReplyAttributes;
import com.mulesoft.connectors.rosettanet.extension.internal.rnif.service.ServiceReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.mule.runtime.api.util.MultiMap;

public abstract class MessageAttributesBuilder {
    MessageAttributes attributes = new MessageAttributes();
    ServiceReader serviceReader;
    byte[] requestData;

    public MessageAttributes build(ServiceReader serviceReader, byte[] requestData, MultiMap<String, String> headers) {
        this.serviceReader = serviceReader;
        this.requestData = requestData;
        this.attributes.setHeaders(headers);
        this.attributes.setMessageId(this.getMessageID());
        this.attributes.setPartnerBusinessId(serviceReader.getPartnerBusinessIdentifier());
        this.attributes.setPartnerLocationId(serviceReader.getPartnerLocationID());
        this.attributes.setReplyAttributes(this.getReplyAttributes());
        this.attributes.setMimeData(new ByteArrayInputStream(requestData));
        this.attributes.setAcknowledgeData(this.getAcknowledgeData());
        return this.attributes;
    }

    abstract String getMessageID();

    private ReplyAttributes getReplyAttributes() {
        ReplyAttributes reply = new ReplyAttributes();
        reply.setMessageId(this.getReplyMessageID());
        reply.setActionId(this.getReplyActionID());
        reply.setPipInstanceId(this.serviceReader.getPipInstanceId());
        return reply;
    }

    abstract String getReplyMessageID();

    abstract String getReplyActionID();

    abstract InputStream getAcknowledgeData();
}

