/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.rosettanet.extension.internal.listener;

import com.mulesoft.connectors.rosettanet.extension.api.MessageAttributes;
import com.mulesoft.connectors.rosettanet.extension.api.config.ForceSigning;
import com.mulesoft.connectors.rosettanet.extension.api.config.PipRole;
import com.mulesoft.connectors.rosettanet.extension.api.data.Completion;
import com.mulesoft.connectors.rosettanet.extension.api.data.CompletionCode;
import com.mulesoft.connectors.rosettanet.extension.api.data.ExceptionDetail;
import com.mulesoft.connectors.rosettanet.extension.crypto.signature.MultiPartCryptoSigner;
import com.mulesoft.connectors.rosettanet.extension.internal.Utility;
import com.mulesoft.connectors.rosettanet.extension.internal.config.RosettaNetConfig;
import com.mulesoft.connectors.rosettanet.extension.internal.config.pip.ActionDetail;
import com.mulesoft.connectors.rosettanet.extension.internal.config.pip.PipDetail;
import com.mulesoft.connectors.rosettanet.extension.internal.delivery.DeliveryManager;
import com.mulesoft.connectors.rosettanet.extension.internal.listener.ConcreteMessageAttributesBuilderByAction;
import com.mulesoft.connectors.rosettanet.extension.internal.listener.ConcreteMessageAttributesBuilderBySignal;
import com.mulesoft.connectors.rosettanet.extension.internal.listener.MessageAttributesDirector;
import com.mulesoft.connectors.rosettanet.extension.internal.rnif.MimeMessageBuilder;
import com.mulesoft.connectors.rosettanet.extension.internal.rnif.MimeUtils;
import com.mulesoft.connectors.rosettanet.extension.internal.rnif.SignedMessageValidator;
import com.mulesoft.connectors.rosettanet.extension.internal.rnif.acknowledge.AcknowledgmentReader;
import com.mulesoft.connectors.rosettanet.extension.internal.rnif.delivery.DeliveryReader;
import com.mulesoft.connectors.rosettanet.extension.internal.rnif.exception.ExceptionReader;
import com.mulesoft.connectors.rosettanet.extension.internal.rnif.preamble.PreambleReader;
import com.mulesoft.connectors.rosettanet.extension.internal.rnif.service.ServiceReader;
import com.mulesoft.connectors.rosettanet.extension.internal.send.SendAcknowledgment;
import com.mulesoft.connectors.rosettanet.extension.internal.send.SendException;
import com.mulesoft.connectors.rosettanet.extension.internal.xml.DocumentRewriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMultipart;
import javax.xml.bind.DatatypeConverter;
import javax.xml.stream.XMLStreamException;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.domain.request.HttpRequestContext;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RosettaRequestHandler
implements RequestHandler {
    private static final Logger logger = LoggerFactory.getLogger(RosettaRequestHandler.class);
    private static final String MISSING_CONTENT_RESPONSE = "<p>No content present</p>";
    private static final String SYNC_REPONSETYPE_RESPONSE = "<p>sync response type not supported</p>";
    private static final String MISSING_MIME_RESPONSE = "<p>Missing required MULTIPART-MIME content</p>";
    private static final String INVALID_FORMAT_RESPONSE = "<p>Invalid message format</p>";
    private static final String SECURITY_ERROR_RESPONSE = "<p>Security error</p>";
    private static final String MISSING_PREAMBLE_RESPONSE = "<p>Missing required RN-Preamble header</p>";
    private static final String INVALID_PREAMBLE_RESPONSE = "<p>Preamble header validation error</p>";
    private static final String MISSING_DELIVERY_RESPONSE = "<p>Missing required RN-Delivery-Header header</p>";
    private static final String INVALID_DELIVERY_RESPONSE = "<p>Delivery header validation error</p>";
    private static final String MISSING_SERVICE_RESPONSE = "<p>Missing required RN-Service-Header header</p>";
    private static final String INVALID_SERVICE_RESPONSE = "<p>Service header validation error</p>";
    private static final String FROMTO_MISMATCH_RESPONSE = "<p>Delivery header from/to indentifiers don't match configuration</p>";
    private static final String REQUIRE_SIGNED_RESPONSE = "<p>Signed message required</p>";
    private static final String REQUIRE_UNSIGNED_RESPONSE = "<p>Signed message not allowed</p>";
    private static final String REQUIRE_SECURETRANSPORT_RESPONSE = "<p>Secure transport connection required</p>";
    private static final String WRONG_USAGE_RESPONSE = "<p>Usage code doesn't match configuration</p>";
    private static final String GENERAL_EXCEPTION_TYPECODE = "General Exception";
    private static final String VALIDATING_SERVICE_CONTENT_ERROR = "UNP.SCON.VALERR";
    private static final String SERVICECONTENT_COMPONENT = "ServiceContent";
    private final String listenerRef;
    private final Map<String, PipConfiguration> actionConfig;
    private final Map<String, PipConfiguration> signalConfig;
    private final Map<String, Integer> aliasUsage;
    private final SignedMessageValidator messageValidator;
    private final DeliveryManager deliveryManager;
    private final MessageAttributesDirector messageAttributesDirector;

    public RosettaRequestHandler(String ref, DeliveryManager delivery) {
        this.listenerRef = ref;
        this.actionConfig = new ConcurrentHashMap<String, PipConfiguration>();
        this.signalConfig = new ConcurrentHashMap<String, PipConfiguration>();
        this.aliasUsage = new ConcurrentHashMap<String, Integer>();
        this.messageValidator = new SignedMessageValidator();
        this.deliveryManager = delivery;
        this.messageAttributesDirector = new MessageAttributesDirector();
    }

    private static boolean isSignedAction(ActionDetail action) {
        return action != null && action.isRequireSignedAction();
    }

    private static boolean isSignedAcknowledge(ActionDetail action) {
        return action != null && action.isRequireSignedAcknowledge();
    }

    private static CryptoUsage checkCrypto(RosettaNetConfig config) {
        CryptoUsage crypto;
        String keystore = config.getKeystorePath();
        String keypass = config.getKeystorePass();
        String pripass = config.getPrivatePass();
        if (keystore == null && keypass == null && pripass == null) {
            crypto = new CryptoUsage(false, false);
        } else if (keystore != null && keypass != null) {
            crypto = pripass == null ? new CryptoUsage(true, false) : new CryptoUsage(true, true);
        } else {
            throw new RuntimeException("Invalid keystore configuration - both keystore and keypass required");
        }
        return crypto;
    }

    private static String buildConfigKey(String pipkey, String alias) {
        return pipkey + ":" + alias;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUsage(RosettaNetConfig config, SourceCallback<InputStream, MessageAttributes> callback) {
        boolean verify;
        boolean sign;
        CryptoUsage crypto = RosettaRequestHandler.checkCrypto(config);
        ActionDetail sendAction = config.getSendAction();
        ActionDetail receiveAction = config.getReceiveAction();
        boolean inputIsAction = callback != null;
        ForceSigning over = config.getSigningOverride();
        boolean bl = inputIsAction && (over == null ? RosettaRequestHandler.isSignedAcknowledge(sendAction) : over.isSigned()) ? true : (sign = false);
        boolean bl2 = over != null ? over.isSigned() : (verify = inputIsAction && RosettaRequestHandler.isSignedAction(receiveAction) || !inputIsAction && RosettaRequestHandler.isSignedAcknowledge(sendAction));
        if (sign && !crypto.canBuildSigned) {
            throw new RuntimeException("Missing keystore configuration for required message signing");
        }
        if (verify && !crypto.canVerifySigned) {
            throw new RuntimeException("Missing keystore configuration for required message signature verification");
        }
        String keystore = config.getKeystorePath();
        String keypass = config.getKeystorePass();
        String pripass = config.getPrivatePass();
        String alias = Utility.concatenateOptional(config.getPartnerBusinessIdentifier(), config.getPartnerLocationId());
        if (crypto.canVerifySigned) {
            Map<String, Integer> map = this.aliasUsage;
            synchronized (map) {
                Integer usage = this.aliasUsage.get(alias);
                if (usage == null) {
                    this.messageValidator.addCertificate(keystore, keypass, alias);
                    usage = 1;
                } else {
                    usage = usage + 1;
                }
                this.aliasUsage.put(alias, usage);
            }
        }
        MimeMessageBuilder signer = null;
        if (crypto.canBuildSigned) {
            String myalias = Utility.concatenateOptional(config.getSelfBusinessIdentifier(), config.getSelfLocationId());
            signer = new MimeMessageBuilder(keystore, keypass, pripass, myalias);
        } else {
            signer = new MimeMessageBuilder();
        }
        PipDetail pipDetail = config.getPipDetail();
        String pipkey = pipDetail.getPipCode() + pipDetail.getPipVersion();
        String fullkey = RosettaRequestHandler.buildConfigKey(pipkey, alias);
        PipConfiguration pipConfig = new PipConfiguration(verify, keystore != null, config.getPipDetail(), config, callback, signer);
        if (inputIsAction) {
            PipConfiguration prior = this.actionConfig.put(fullkey, pipConfig);
            logger.debug("Added action handling for PIP [" + pipkey + "] with partner p" + alias + "] to HTTP listener [" + this.listenerRef + "]");
            if (prior != null && (config != prior.connectorConfig || callback != prior.sourceCallback)) {
                throw new RuntimeException("Conflicting configuration for listener [" + config.getListenerConfigName() + "] PIP [" + pipkey + "] with partner [" + alias + "]");
            }
        } else {
            this.signalConfig.put(fullkey, pipConfig);
            logger.debug("Added signal handling for PIP [" + pipkey + "] with partner [" + alias + "] to HTTP listener [" + this.listenerRef + "]");
        }
    }

    public int removeUsage(RosettaNetConfig config, boolean action) {
        Integer usage;
        CryptoUsage crypto = RosettaRequestHandler.checkCrypto(config);
        PipDetail pipDetail = config.getPipDetail();
        String alias = Utility.concatenateOptional(config.getPartnerBusinessIdentifier(), config.getPartnerLocationId());
        if (crypto.canVerifySigned && (usage = this.aliasUsage.get(alias)) != null) {
            if (usage == 1) {
                this.aliasUsage.remove(alias);
                this.messageValidator.removeCertificate(alias);
            } else if (usage > 1) {
                usage = usage - 1;
                this.aliasUsage.put(alias, usage);
            }
        }
        String pipkey = pipDetail.getPipCode() + pipDetail.getPipVersion();
        String fullkey = RosettaRequestHandler.buildConfigKey(pipkey, alias);
        if (action) {
            this.actionConfig.remove(fullkey);
            logger.debug("Removed action handling for PIP [" + pipkey + "] with partner [" + alias + "] to HTTP listener [" + this.listenerRef + "]");
        } else {
            this.signalConfig.remove(fullkey);
            logger.debug("Removed signal handling for PIP [" + pipkey + "] with partner [" + alias + "] to HTTP listener [" + this.listenerRef + "]");
        }
        logger.debug("After removal signal count is [" + this.signalConfig.size() + "] and action count is [" + this.actionConfig.size() + "]");
        return this.signalConfig.size() + this.actionConfig.size();
    }

    private void sendResponse(int code, String reason, String body, HttpResponseReadyCallback callback) {
        ByteArrayHttpEntity entity = new ByteArrayHttpEntity(body.getBytes(Utility.CHARSET_UTF8));
        HttpResponse response = ((HttpResponseBuilder)HttpResponse.builder().statusCode(Integer.valueOf(code)).reasonPhrase(reason).entity((HttpEntity)entity)).build();
        callback.responseReady(response, new ResponseStatusCallback(){

            public void responseSendFailure(Throwable throwable) {
            }

            public void responseSendSuccessfully() {
            }
        });
    }

    private byte[] mimeMessage(String ctypes, byte[] body) {
        StringBuilder builder = new StringBuilder();
        builder.append("MIME-Version: 1.0\n");
        builder.append("Content-type: ");
        builder.append(ctypes);
        builder.append("\n\n");
        byte[] header = builder.toString().getBytes(Charset.forName("ASCII"));
        byte[] data = new byte[body.length + header.length];
        System.arraycopy(header, 0, data, 0, header.length);
        System.arraycopy(body, 0, data, header.length, body.length);
        return data;
    }

    public void handleRequest(HttpRequestContext context, HttpResponseReadyCallback callback) {
        try {
            String rtype;
            HttpRequest request = context.getRequest();
            this.messageAttributesDirector.setHeadersMap((MultiMap<String, String>)request.getHeaders());
            if (logger.isDebugEnabled()) {
                StringBuilder builder = new StringBuilder("Received request message with headers:");
                for (String name : request.getHeaderNames()) {
                    builder.append('\n');
                    builder.append(name);
                    builder.append(": ");
                    boolean first = true;
                    for (String value : request.getHeaderValues(name)) {
                        if (first) {
                            first = false;
                        } else {
                            builder.append("; ");
                        }
                        builder.append(value);
                    }
                }
                logger.debug(builder.toString());
            }
            if ("sync".equals(rtype = request.getHeaderValue("x-RN-Response-Type"))) {
                this.sendResponse(501, "Not Supported", SYNC_REPONSETYPE_RESPONSE, callback);
            } else {
                boolean secure = "https".equals(context.getScheme());
                this.interpretRequestBody(request, secure, callback);
            }
        }
        catch (Exception e) {
            logger.error("Error processing message", (Throwable)e);
            this.sendResponse(400, "Bad Request", INVALID_FORMAT_RESPONSE, callback);
        }
    }

    private void interpretRequestBody(HttpRequest request, boolean secure, HttpResponseReadyCallback callback) throws IOException {
        HttpEntity streamEntity = request.getEntity();
        if (streamEntity == null) {
            this.sendResponse(400, "Bad Request", MISSING_CONTENT_RESPONSE, callback);
        } else {
            InputStream is = streamEntity.getContent();
            byte[] data = Utility.readFully(is);
            if (logger.isTraceEnabled()) {
                logger.trace("Encoded message data:\n" + DatatypeConverter.printBase64Binary((byte[])data));
            }
            Collection types = request.getHeaderValuesIgnoreCase("content-type");
            boolean multi = false;
            boolean boundary = false;
            StringBuilder builder = new StringBuilder();
            for (String type : types) {
                String lower = type.toLowerCase();
                if (lower.contains("multipart/related")) {
                    multi = true;
                }
                if (lower.contains("boundary=")) {
                    boundary = true;
                }
                if (builder.length() > 0) {
                    builder.append("; ");
                }
                builder.append(type);
            }
            logger.debug("Processing request with reported content types: " + builder.toString());
            if (multi) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Received request data:\n" + new String(data, Utility.CHARSET_UTF8));
                }
                MimeMultipart mimemp = null;
                if (boundary) {
                    byte[] msg = this.mimeMessage(builder.toString(), data);
                    mimemp = MimeUtils.getMimeContent((byte[])msg);
                } else {
                    String text = new String(data, Utility.CHARSET_UTF8);
                    boolean valid = false;
                    Exception ex = null;
                    if (text.startsWith("--")) {
                        int end;
                        for (end = 2; end < text.length() && text.charAt(end) != '\r' && text.charAt(end) != '\n'; ++end) {
                        }
                        if (end < text.length()) {
                            builder.append(" boundary=\"");
                            builder.append(text.substring(2, end).trim());
                            builder.append("\";");
                            logger.debug("Trying Content-Type " + builder.toString());
                            byte[] msg = this.mimeMessage(builder.toString(), data);
                            try {
                                mimemp = MimeUtils.getMimeContent((byte[])msg);
                                valid = MimeUtils.getPreambleHeader((MimeMultipart)mimemp) != null;
                            }
                            catch (Exception e) {
                                ex = e;
                            }
                            if (!valid) {
                                builder.append(" type=\"multipart/signed\";");
                                logger.debug("Trying Content-Type " + builder.toString());
                                msg = this.mimeMessage(builder.toString(), data);
                                try {
                                    mimemp = MimeUtils.getMimeContent((byte[])msg);
                                    valid = this.messageValidator.isSigned(mimemp);
                                }
                                catch (Exception e) {
                                    ex = e;
                                }
                            }
                        }
                    }
                    if (!valid) {
                        throw new IOException("Invalid Content-Type failed finding boundary", ex);
                    }
                }
                RequestProcessor processor = new RequestProcessor(data, secure, callback);
                processor.handleMime(mimemp);
            } else {
                this.sendResponse(400, "Bad Request", MISSING_MIME_RESPONSE, callback);
            }
        }
    }

    private static class PipConfiguration {
        public final boolean requireSigned;
        public final boolean allowSigned;
        public final PipDetail pipDetail;
        public final RosettaNetConfig connectorConfig;
        public final SourceCallback<InputStream, MessageAttributes> sourceCallback;
        public final MimeMessageBuilder messageSigner;

        private PipConfiguration(boolean require, boolean allow, PipDetail detail, RosettaNetConfig config, SourceCallback<InputStream, MessageAttributes> callback, MimeMessageBuilder signer) {
            this.requireSigned = require;
            this.allowSigned = allow;
            this.pipDetail = detail;
            this.connectorConfig = config;
            this.sourceCallback = callback;
            this.messageSigner = signer;
        }
    }

    private static class CryptoUsage {
        public final boolean canVerifySigned;
        public final boolean canBuildSigned;

        public CryptoUsage(boolean verify, boolean build) {
            this.canVerifySigned = verify;
            this.canBuildSigned = build;
        }
    }

    private class RequestProcessor {
        private final HttpResponseReadyCallback responseCallback;
        private final byte[] requestData;
        private final boolean secureTransport;
        private MimeMultipart mimeMultipart;
        private List<MultiPartCryptoSigner.ValidationInformation> validationMatches;
        private byte[] messageDigest;

        public RequestProcessor(byte[] data, boolean https, HttpResponseReadyCallback response) throws IOException {
            this.requestData = data;
            this.secureTransport = https;
            this.responseCallback = response;
        }

        private void reportResponse(int code, String reason, String body) {
            RosettaRequestHandler.this.sendResponse(code, reason, body, this.responseCallback);
        }

        public void handleMime(MimeMultipart mimemp) {
            try {
                if (RosettaRequestHandler.this.messageValidator != null && RosettaRequestHandler.this.messageValidator.isSigned(mimemp)) {
                    this.validationMatches = RosettaRequestHandler.this.messageValidator.validateSignature(mimemp);
                    if (this.validationMatches.size() > 0) {
                        this.mimeMultipart = RosettaRequestHandler.this.messageValidator.getSignedContent(mimemp);
                        this.handlePreambleHeader();
                    } else {
                        logger.error("Signature failed verification");
                        this.reportResponse(400, "Bad Request", RosettaRequestHandler.SECURITY_ERROR_RESPONSE);
                    }
                } else {
                    if (RosettaRequestHandler.this.messageValidator == null) {
                        logger.error("Signature not supported (may be spurious during initialization)");
                        this.reportResponse(400, "Bad Request", RosettaRequestHandler.SECURITY_ERROR_RESPONSE);
                        return;
                    }
                    this.mimeMultipart = MimeUtils.getUnsigned((MimeMultipart)mimemp);
                    if (this.mimeMultipart == null) {
                        this.mimeMultipart = mimemp;
                    }
                    this.handlePreambleHeader();
                }
            }
            catch (Exception e) {
                logger.error("Error processing message data", (Throwable)e);
                this.reportResponse(400, "Bad Request", RosettaRequestHandler.INVALID_FORMAT_RESPONSE);
            }
        }

        private void handlePreambleHeader() {
            InputStream prestream;
            if (logger.isDebugEnabled()) {
                try {
                    StringBuilder builder = new StringBuilder();
                    int count = this.mimeMultipart.getCount();
                    builder.append("Message contains " + count + " parts:");
                    for (int i = 0; i < count; ++i) {
                        String[] headers;
                        BodyPart part = this.mimeMultipart.getBodyPart(i);
                        builder.append("\n " + i + ":");
                        for (String header : headers = part.getHeader("Content-Location")) {
                            builder.append(" ");
                            builder.append(header);
                        }
                    }
                    logger.debug(builder.toString());
                }
                catch (MessagingException e) {
                    logger.debug("Unable to scan MIME multipart content", (Throwable)e);
                }
            }
            if ((prestream = MimeUtils.getPreambleHeader((MimeMultipart)this.mimeMultipart)) == null) {
                logger.error("Preamble header not present");
                this.reportResponse(400, "Bad Request", RosettaRequestHandler.MISSING_PREAMBLE_RESPONSE);
            } else {
                try {
                    PreambleReader prerdr = new PreambleReader(prestream);
                    prerdr.read();
                    this.handleDeliveryHeader();
                }
                catch (XMLStreamException e) {
                    logger.error("Error processing preamble header", (Throwable)e);
                    this.reportResponse(400, "Bad Request", RosettaRequestHandler.INVALID_PREAMBLE_RESPONSE);
                }
            }
        }

        private void handleDeliveryHeader() {
            InputStream delstream = MimeUtils.getDeliveryHeader((MimeMultipart)this.mimeMultipart);
            if (delstream == null) {
                logger.error("Delivery header not present");
                this.reportResponse(400, "Bad Request", RosettaRequestHandler.MISSING_DELIVERY_RESPONSE);
            } else {
                try {
                    DeliveryReader delrdr = new DeliveryReader(delstream);
                    delrdr.read();
                    if (this.validationMatches != null) {
                        String fromid = delrdr.getFromBusinessIdentifier();
                        String expect = Utility.concatenateOptional(fromid, delrdr.getFromLocationIdentifier());
                        MultiPartCryptoSigner.ValidationInformation match = null;
                        for (MultiPartCryptoSigner.ValidationInformation info : this.validationMatches) {
                            String alias = info.getCertificateAlias();
                            if (!alias.equalsIgnoreCase(expect) && !alias.equalsIgnoreCase(fromid)) continue;
                            match = info;
                            this.messageDigest = info.getDigestValue();
                            if (!logger.isTraceEnabled()) break;
                            String digest = DatatypeConverter.printBase64Binary((byte[])this.messageDigest);
                            logger.trace("Matched alias [" + alias + "] with message digest [" + digest + "]");
                            break;
                        }
                        if (match == null) {
                            logger.error("Signing certificate does not match partner information in deliver header (found [" + this.validationMatches.size() + "] certificates, but none with alias [" + expect + "])");
                            this.reportResponse(400, "Bad Request", RosettaRequestHandler.INVALID_DELIVERY_RESPONSE);
                        }
                    }
                    this.handleServiceHeader(delrdr);
                }
                catch (XMLStreamException e) {
                    logger.error("Error processing delivery header");
                    this.reportResponse(400, "Bad Request", RosettaRequestHandler.INVALID_DELIVERY_RESPONSE);
                }
            }
        }

        private void handleServiceHeader(DeliveryReader delrdr) {
            InputStream serstream = MimeUtils.getServiceHeader((MimeMultipart)this.mimeMultipart);
            if (serstream == null) {
                logger.error("Service header not present");
                this.reportResponse(400, "Bad Request", RosettaRequestHandler.MISSING_SERVICE_RESPONSE);
            } else {
                try {
                    ServiceReader servrdr = new ServiceReader(serstream);
                    servrdr.read();
                    this.handleServiceContent(delrdr, servrdr);
                }
                catch (XMLStreamException e) {
                    logger.error("Error processing service header");
                    this.reportResponse(400, "Bad Request", RosettaRequestHandler.INVALID_SERVICE_RESPONSE);
                }
            }
        }

        private boolean nonNullEquals(String a, String b) {
            return a == null || a.equals(b);
        }

        private boolean verifyConfiguration(DeliveryReader delrdr, PipConfiguration pconfig) {
            RosettaNetConfig cconfig = pconfig.connectorConfig;
            if (!(cconfig.getPartnerBusinessIdentifier().equals(delrdr.getFromBusinessIdentifier()) && cconfig.getSelfBusinessIdentifier().equals(delrdr.getToBusinessIdentifier()) && this.nonNullEquals(cconfig.getPartnerLocationId(), delrdr.getFromLocationIdentifier()) && this.nonNullEquals(cconfig.getSelfLocationId(), delrdr.getToLocationIdentifier()))) {
                logger.error("Delivery header from/to identification doesn't match configuration");
                this.reportResponse(400, "Bad Request", RosettaRequestHandler.FROMTO_MISMATCH_RESPONSE);
                return false;
            }
            if (this.messageDigest == null) {
                if (pconfig.requireSigned) {
                    logger.error("Message signing required");
                    this.reportResponse(400, "Bad Request", RosettaRequestHandler.REQUIRE_SIGNED_RESPONSE);
                    return false;
                }
            } else if (!pconfig.allowSigned) {
                logger.error("Message signing not allowed");
                this.reportResponse(400, "Bad Request", RosettaRequestHandler.REQUIRE_UNSIGNED_RESPONSE);
                return false;
            }
            if (!this.secureTransport && cconfig.getRequireSecureTransport()) {
                logger.error("Secure transport required");
                this.reportResponse(400, "Bad Request", RosettaRequestHandler.REQUIRE_SECURETRANSPORT_RESPONSE);
                return false;
            }
            return true;
        }

        private boolean verifyUsage(ServiceReader servrdr, PipConfiguration pconfig) {
            RosettaNetConfig connConfig = pconfig.connectorConfig;
            if (connConfig.getGlobalUsageCode().toString().equalsIgnoreCase(servrdr.getUsageCode())) {
                return true;
            }
            logger.error("Global usage code doesn't match configuration");
            this.reportResponse(400, "Bad Request", RosettaRequestHandler.WRONG_USAGE_RESPONSE);
            return false;
        }

        private void handleServiceContent(DeliveryReader delrdr, ServiceReader servrdr) {
            logger.debug(String.format("Handling service content with messageTrackingID: %s and replyMsgId: %s", delrdr.getMessageTrackingID(), servrdr.getReplyMsgId()));
            String pipkey = servrdr.getPipCode() + servrdr.getPipVersion();
            String alias = Utility.concatenateOptional(delrdr.getFromBusinessIdentifier(), delrdr.getFromLocationIdentifier());
            String fullkey = RosettaRequestHandler.buildConfigKey(pipkey, alias);
            String shortKey = RosettaRequestHandler.buildConfigKey(pipkey, delrdr.getFromBusinessIdentifier());
            InputStream cs = MimeUtils.getServiceContent((MimeMultipart)this.mimeMultipart);
            if (cs == null) {
                logger.error("Service content not present");
                this.reportResponse(400, "Bad Request", RosettaRequestHandler.MISSING_CONTENT_RESPONSE);
            }
            logger.debug("Sending 202 (Accepted) response");
            this.reportResponse(202, "Accepted", "");
            if (servrdr.getActionIdentity() != null) {
                logger.debug("The Action Identity is: " + servrdr.getActionIdentity());
                logger.info("Configuration for action received with PIP [" + fullkey + "]");
                PipConfiguration pipConfig = (PipConfiguration)RosettaRequestHandler.this.actionConfig.get(fullkey);
                if (pipConfig == null) {
                    logger.error("No configuration found for action received with PIP [" + pipkey + "] and alias [" + alias + "]");
                    logger.warn("Configuration was null");
                    logger.info("Configuration was null");
                    logger.debug("Configuration was null");
                } else if (this.verifyConfiguration(delrdr, pipConfig) && this.verifyUsage(servrdr, pipConfig)) {
                    String toService;
                    String toRole;
                    String fromService;
                    String fromRole;
                    ActionDetail action;
                    RosettaNetConfig connConfig = pipConfig.connectorConfig;
                    PipDetail pip = pipConfig.pipDetail;
                    if (PipRole.INITIATOR == connConfig.getPipRole()) {
                        action = pip.getResponderAction();
                        fromRole = pip.getResponderPartnerRole();
                        fromService = pip.getResponderServiceCode();
                        toRole = pip.getInitiatorPartnerRole();
                        toService = pip.getInitiatorServiceCode();
                    } else {
                        action = pip.getInitiatorAction();
                        fromRole = pip.getInitiatorPartnerRole();
                        fromService = pip.getInitiatorServiceCode();
                        toRole = pip.getResponderPartnerRole();
                        toService = pip.getResponderServiceCode();
                    }
                    if (action != null && action.getActionCode().equals(servrdr.getActionIdentity())) {
                        if (fromRole.equals(servrdr.getFromRole()) && fromService.equals(servrdr.getFromService()) && toRole.equals(servrdr.getToRole()) && toService.equals(servrdr.getToService())) {
                            String directory = Utility.directoryPath(connConfig.getPipFile());
                            ByteArrayOutputStream bos = new ByteArrayOutputStream();
                            ForceSigning over = connConfig.getSigningOverride();
                            boolean sign = over == null ? action.isRequireSignedAcknowledge() : over.isSigned();
                            try {
                                new DocumentRewriter(cs, null, action.getDtdName(), directory, bos).rewrite();
                                byte[] data = bos.toByteArray();
                                SendAcknowledgment acker = new SendAcknowledgment(pipConfig.messageSigner, sign, connConfig, servrdr.getActionIdentity(), delrdr.getMessageTrackingID(), servrdr.getPipInstanceId(), this.messageDigest);
                                MessageAttributes attrs = RosettaRequestHandler.this.messageAttributesDirector.setBuilder(new ConcreteMessageAttributesBuilderByAction(delrdr, acker.getMimeBytes())).setContext(servrdr, this.requestData).generateAttributes();
                                logger.debug("Sending acknowledgment with messageId: " + attrs.getMessageId());
                                connConfig.getSendExecutor().execute(acker);
                                pipConfig.sourceCallback.handle(Result.builder().output((Object)new ByteArrayInputStream(data)).attributes((Object)attrs).build());
                            }
                            catch (IOException | XMLStreamException e) {
                                logger.error("", (Throwable)e);
                                SendException except = new SendException(pipConfig.messageSigner, sign, connConfig, servrdr.getActionIdentity(), delrdr.getMessageTrackingID(), servrdr.getPipInstanceId(), RosettaRequestHandler.GENERAL_EXCEPTION_TYPECODE, RosettaRequestHandler.VALIDATING_SERVICE_CONTENT_ERROR, e.getMessage(), RosettaRequestHandler.SERVICECONTENT_COMPONENT);
                                connConfig.getSendExecutor().execute(except);
                            }
                        } else {
                            logger.error("Receive message roles and/or services don't match configuration");
                        }
                    } else {
                        logger.error("Receive message with wrong action");
                    }
                }
            } else if (servrdr.getSignalCode() != null) {
                PipConfiguration pipConfig;
                logger.debug("The Signal Code is: " + servrdr.getSignalCode());
                PipConfiguration pipConfiguration = pipConfig = RosettaRequestHandler.this.signalConfig.get(fullkey) != null ? (PipConfiguration)RosettaRequestHandler.this.signalConfig.get(fullkey) : (PipConfiguration)RosettaRequestHandler.this.signalConfig.get(shortKey);
                if (pipConfig == null) {
                    logger.error("No configuration found for signal received with PIP [" + pipkey + "] and alias [" + alias + "]");
                } else if (this.verifyConfiguration(delrdr, pipConfig)) {
                    RosettaNetConfig connConfig = pipConfig.connectorConfig;
                    MessageAttributes attrs = RosettaRequestHandler.this.messageAttributesDirector.setBuilder(new ConcreteMessageAttributesBuilderBySignal()).setContext(servrdr, this.requestData).generateAttributes();
                    Completion complete = new Completion();
                    if ("Receipt Acknowledgment".equals(servrdr.getSignalCode())) {
                        logger.debug("Handling Receipt Acknowledgment signal");
                        try {
                            AcknowledgmentReader ackver = new AcknowledgmentReader(cs);
                            ackver.read();
                            complete.setCompletionCode(CompletionCode.SUCCESS);
                            RosettaRequestHandler.this.deliveryManager.handleCompletion(complete, attrs, connConfig);
                        }
                        catch (Exception e) {
                            logger.error("Error processing acknowledgment signal", (Throwable)e);
                        }
                    } else if ("Exception".equals(servrdr.getSignalCode())) {
                        logger.debug("Handling Exception signal");
                        try {
                            ExceptionReader excver = new ExceptionReader(cs);
                            excver.read();
                            complete.setCompletionCode(CompletionCode.EXCEPTION);
                            ExceptionDetail detail = new ExceptionDetail();
                            complete.setExceptionDetail(detail);
                            detail.setExceptionCode(excver.getExceptionCode());
                            detail.setExceptionErrorDescription(excver.getFreeFormText());
                            detail.setExceptionComponentCode(excver.getComponentCode());
                            detail.setExceptionType(excver.getExceptionType());
                            RosettaRequestHandler.this.deliveryManager.handleCompletion(complete, attrs, connConfig);
                        }
                        catch (Exception e) {
                            logger.error("Error processing acknowledgment signal", (Throwable)e);
                        }
                    } else {
                        logger.error("Unknown signal " + servrdr.getSignalCode());
                    }
                }
            } else {
                logger.error("Unknown message action " + servrdr.getActionIdentity());
            }
        }
    }
}

