/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.rosettanet.extension.internal.metadata;

import com.mulesoft.connectors.rosettanet.extension.internal.Utility;
import com.mulesoft.connectors.rosettanet.extension.internal.config.RosettaNetConfig;
import com.mulesoft.connectors.rosettanet.extension.internal.config.pip.ActionDetail;
import java.io.InputStream;
import java.util.Collections;
import javax.xml.namespace.QName;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.xml.api.ModelFactory;
import org.mule.metadata.xml.api.XmlTypeLoader;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.InputTypeResolver;

public class SendActionResolver
implements InputTypeResolver {
    public MetadataType getInputMetadata(MetadataContext context, Object key) throws MetadataResolvingException {
        RosettaNetConfig config = (RosettaNetConfig)context.getConfig().orElseThrow(() -> new MetadataResolvingException("No configuration supplied for metadata generation", FailureCode.INVALID_CONFIGURATION));
        ActionDetail action = config.getSendAction();
        String pipFile = config.getPipFile();
        if (action == null) {
            throw new MetadataResolvingException("No send action defined for PIP [" + pipFile + "]", FailureCode.INVALID_CONFIGURATION);
        }
        String xsdPath = Utility.directoryPath(pipFile) + action.getXsdName();
        InputStream xsdStream = Utility.findResource(xsdPath);
        if (xsdStream == null) {
            throw new IllegalArgumentException("XSD not found at [" + xsdPath + "] (base path [" + pipFile + "])");
        }
        ModelFactory factory = ModelFactory.fromSchemas(Collections.singletonMap(action.getXsdName(), xsdStream));
        XmlTypeLoader typeLoader = new XmlTypeLoader(factory);
        QName qName = new QName(config.getSendRoot());
        return (MetadataType)typeLoader.load(qName, null).orElseThrow(() -> new MetadataResolvingException("Unable to load metadata from schema definition for PIP [" + pipFile + "]", FailureCode.INVALID_CONFIGURATION));
    }

    public String getCategoryName() {
        return "RosettaNet";
    }
}

