/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.rosettanet.extension.internal.operation;

import com.mulesoft.connectors.rosettanet.extension.api.MessageAttributes;
import com.mulesoft.connectors.rosettanet.extension.api.ReplyAttributes;
import com.mulesoft.connectors.rosettanet.extension.api.config.ForceSigning;
import com.mulesoft.connectors.rosettanet.extension.api.config.PipRole;
import com.mulesoft.connectors.rosettanet.extension.internal.MimeData;
import com.mulesoft.connectors.rosettanet.extension.internal.Utility;
import com.mulesoft.connectors.rosettanet.extension.internal.config.RosettaNetConfig;
import com.mulesoft.connectors.rosettanet.extension.internal.config.pip.ActionDetail;
import com.mulesoft.connectors.rosettanet.extension.internal.exception.TypeProvider;
import com.mulesoft.connectors.rosettanet.extension.internal.exception.WriteException;
import com.mulesoft.connectors.rosettanet.extension.internal.metadata.SendActionResolver;
import com.mulesoft.connectors.rosettanet.extension.internal.rnif.MimeUtils;
import com.mulesoft.connectors.rosettanet.extension.internal.rnif.RosettaData;
import com.mulesoft.connectors.rosettanet.extension.internal.xml.DocumentRewriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.mail.internet.MimeMultipart;
import javax.xml.stream.XMLStreamException;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Throws(value={TypeProvider.class})
public class RosettaNetOperations {
    private static final Logger logger = LoggerFactory.getLogger(RosettaNetOperations.class);

    @MediaType(value="application/xml")
    public Result<InputStream, MessageAttributes> sendAction(@Config RosettaNetConfig config, @DisplayName(value="Initiating action") @Optional ReplyAttributes replyTo, @Content @TypeResolver(value=SendActionResolver.class) InputStream content) {
        RosettaData rdata;
        boolean sign;
        ActionDetail action = config.getSendAction();
        String root = config.getSendRoot();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        String directory = Utility.directoryPath(config.getPipFile());
        try {
            new DocumentRewriter(content, root, action.getDtdName(), directory, bos).rewrite();
        }
        catch (XMLStreamException e) {
            throw new WriteException("XML processing error", (Throwable)e);
        }
        catch (IOException e) {
            throw new WriteException("Error reading or writing XML data", (Throwable)e);
        }
        byte[] data = bos.toByteArray();
        ForceSigning over = config.getSigningOverride();
        boolean bl = sign = over == null ? action.isRequireSignedAction() : over.isSigned();
        if (config.getPipRole() == PipRole.INITIATOR) {
            rdata = config.getMessageBuilder().buildActionMessage(sign, null, null, null, config, data);
        } else {
            String pipInstance;
            String replyMsg;
            String replyAction;
            if (replyTo == null) {
                logger.warn("Missing expected replyTo attributes for response action message");
                replyAction = null;
                replyMsg = null;
                pipInstance = null;
            } else {
                replyAction = replyTo.getActionId();
                replyMsg = replyTo.getMessageId();
                pipInstance = replyTo.getPipInstanceId();
            }
            rdata = config.getMessageBuilder().buildActionMessage(sign, replyAction, replyMsg, pipInstance, config, data);
        }
        MimeData mdata = MimeUtils.buildMimeData((boolean)sign, (MimeMultipart)rdata.getMimeMultipart());
        config.getDeliveryManager().sendAction(mdata, rdata.getMessageId(), config);
        MessageAttributes attrs = new MessageAttributes();
        attrs.setMessageId(rdata.getMessageId());
        attrs.setPartnerBusinessId(config.getPartnerBusinessIdentifier());
        attrs.setPartnerLocationId(config.getPartnerLocationId());
        attrs.setMimeData(new ByteArrayInputStream(mdata.getBody()));
        attrs.setAcknowledgeData(new ByteArrayInputStream(new byte[0]));
        return Result.builder().output((Object)new ByteArrayInputStream(mdata.getBody())).attributes((Object)attrs).build();
    }
}

