/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.rosettanet.extension.internal.rnif;

import com.mulesoft.connectors.rosettanet.extension.crypto.signature.MultiPartCryptoSigner;
import com.mulesoft.connectors.rosettanet.extension.crypto.signature.SigningAlgorithm;
import com.mulesoft.connectors.rosettanet.extension.internal.Utility;
import com.mulesoft.connectors.rosettanet.extension.internal.config.RosettaNetConfig;
import com.mulesoft.connectors.rosettanet.extension.internal.rnif.RosettaData;
import com.mulesoft.connectors.rosettanet.extension.internal.rnif.delivery.DeliveryWriter;
import com.mulesoft.connectors.rosettanet.extension.internal.rnif.preamble.PreambleWriter;
import com.mulesoft.connectors.rosettanet.extension.internal.rnif.service.ServiceWriter;
import com.mulesoft.connectors.rosettanet.extension.internal.utils.FipsUtils;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimeMessageBuilder {
    private static final Logger logger = LoggerFactory.getLogger(MimeMessageBuilder.class);
    private static final String prefixText;
    private static AtomicInteger messageNumber;
    private final KeyStore keyStore;
    private final String signAlias;
    private final char[] keyPass;
    private SigningAlgorithm signingAlgorithm;

    public MimeMessageBuilder() {
        this.keyStore = null;
        this.signAlias = null;
        this.keyPass = null;
    }

    public MimeMessageBuilder(String kspath, String kspass, String pkpass, String alias) {
        PrivateKey key;
        try {
            String type = FipsUtils.isFipsMode() ? "BCFKS" : "JKS";
            this.keyStore = KeyStore.getInstance(type);
        }
        catch (KeyStoreException e) {
            String errorMsg = FipsUtils.isFipsMode() ? "The keystore you are trying to use is not available in FIPS Mode. Consider using a BCFKS keystore" : "Unable to initialize JKS keystore";
            logger.error(errorMsg);
            throw new RuntimeException(errorMsg, e);
        }
        char[] charArray = kspass.toCharArray();
        InputStream is = Utility.findResource(kspath);
        if (is == null) {
            String message = "Keystore " + kspath + " not found";
            logger.error(message);
            throw new RuntimeException(message);
        }
        try {
            this.keyStore.load(is, charArray);
        }
        catch (Exception e) {
            String message = FipsUtils.isFipsMode() ? "The keystore you are trying to use is not available in FIPS Mode. Consider using a BCFKS keystore" : "Error loading keystore " + kspath + " - check keystore password";
            logger.error(message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
        this.keyPass = pkpass.toCharArray();
        this.signAlias = alias;
        try {
            key = (PrivateKey)this.keyStore.getKey(this.signAlias, this.keyPass);
        }
        catch (Exception e) {
            String text = "Error attempting to load private key from keystore " + kspath;
            logger.error(text, (Throwable)e);
            throw new RuntimeException(text, e);
        }
        if (key == null) {
            String text = "Failed loading private key " + alias + " from keystore " + kspath + " - check private key password";
            logger.error(text);
            throw new RuntimeException(text);
        }
    }

    private static void addPart(byte[] data, String desc, String loc, MimeMultipart multi) {
        MimeBodyPart part;
        InternetHeaders headers = new InternetHeaders();
        headers.addHeader("Content-Type", "application/xml; charset=\"utf-8\"");
        headers.addHeader("Content-Transfer-Encoding", "quoted-printable");
        headers.addHeader("Content-Description", desc);
        headers.addHeader("Content-Location", loc);
        headers.addHeader("Content-ID", UUID.randomUUID().toString());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            OutputStream encode = MimeUtility.encode((OutputStream)bos, (String)"quoted-printable");
            encode.write(data);
            encode.close();
            data = bos.toByteArray();
            part = new MimeBodyPart(headers, data);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating message part " + loc, e);
        }
        try {
            multi.addBodyPart((BodyPart)part);
            if (logger.isTraceEnabled()) {
                logger.trace("multi now has " + multi.getCount() + " parts after adding:\n" + new String(data, Utility.CHARSET_UTF8));
            }
        }
        catch (MessagingException e) {
            throw new RuntimeException("Error adding message part " + loc, e);
        }
    }

    private RosettaData buildMessage(boolean sign, String sigCode, String sigVer, String replyAction, String replyId, String instance, RosettaNetConfig config, byte[] content) {
        RosettaMimeMultipart multi = new RosettaMimeMultipart("related");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PreambleWriter preamble = new PreambleWriter(bos, 1);
        preamble.write(config);
        MimeMessageBuilder.addPart(bos.toByteArray(), "Preamble_MP", "RN-Preamble", multi);
        String numberHex = Integer.toHexString(messageNumber.getAndIncrement());
        String msgId = prefixText + numberHex;
        String pipInstance = instance;
        if (pipInstance == null) {
            pipInstance = config.getPipDetail().getPipCode() + config.getPipDetail().getPipVersion() + msgId;
        }
        bos = new ByteArrayOutputStream();
        DeliveryWriter delivery = new DeliveryWriter(msgId, bos, 1);
        delivery.write(config);
        MimeMessageBuilder.addPart(bos.toByteArray(), "DeliveryHeader_MP", "RN-Delivery-Header", multi);
        bos = new ByteArrayOutputStream();
        ServiceWriter service = new ServiceWriter(sigCode, sigVer, replyAction, replyId, pipInstance, bos, 1);
        service.write(config);
        MimeMessageBuilder.addPart(bos.toByteArray(), "body", "RN-Service-Header", multi);
        MimeMessageBuilder.addPart(content, "ServiceContent_MP", "RN-Service-Content", multi);
        if (sign) {
            if (this.keyStore == null) {
                throw new RuntimeException("Signing required but not supported by configuration");
            }
            SigningAlgorithm algorithm = this.resolveAlgorithm(config);
            MultiPartCryptoSigner crypto = new MultiPartCryptoSigner(this.keyStore, this.signAlias, this.keyPass, algorithm);
            return new RosettaData(msgId, crypto.sign((MimeMultipart)multi));
        }
        return new RosettaData(msgId, multi);
    }

    public RosettaData buildActionMessage(boolean sign, String replyAction, String replyId, String instance, RosettaNetConfig config, byte[] content) {
        return this.buildMessage(sign, null, null, replyAction, replyId, instance, config, content);
    }

    public RosettaData buildSignalMessage(boolean sign, String sigCode, String sigVer, String replyAction, String replyId, String instance, RosettaNetConfig config, byte[] content) {
        return this.buildMessage(sign, sigCode, sigVer, replyAction, replyId, instance, config, content);
    }

    private SigningAlgorithm resolveAlgorithm(RosettaNetConfig config) {
        SigningAlgorithm selected = config.getSigningAlgorithm();
        if (selected == null) {
            return SigningAlgorithm.SHA256;
        }
        return selected;
    }

    static {
        byte[] byts = new SecureRandom().generateSeed(32);
        prefixText = DatatypeConverter.printBase64Binary((byte[])byts);
        messageNumber = new AtomicInteger();
    }

    private static class RosettaMimeMultipart
    extends MimeMultipart {
        public RosettaMimeMultipart(String subtype) {
            super(subtype);
        }

        public String getContentType() {
            return super.getContentType() + "; type=\"application/xml\"";
        }
    }
}

