/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.rosettanet.extension.internal.rnif;

import com.mulesoft.connectors.rosettanet.extension.crypto.signature.CryptoSigner;
import com.mulesoft.connectors.rosettanet.extension.crypto.signature.MultiPartCryptoSigner;
import com.mulesoft.connectors.rosettanet.extension.internal.Utility;
import com.mulesoft.connectors.rosettanet.extension.internal.utils.FipsUtils;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.util.List;
import javax.mail.internet.MimeMultipart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignedMessageValidator {
    private static final Logger logger = LoggerFactory.getLogger(SignedMessageValidator.class);
    private final KeyStore certificateStore;
    private final CryptoSigner crypto;
    private final String keyStoreType = FipsUtils.isFipsMode() ? "BCFKS" : "JKS";

    public SignedMessageValidator() {
        try {
            this.certificateStore = KeyStore.getInstance(this.keyStoreType);
            this.certificateStore.load(null, null);
        }
        catch (Exception e) {
            String errorMsg = FipsUtils.isFipsMode() ? "The keystore you are trying to use is not available in FIPS Mode. Consider using a BCFKS keystore" : "Unable to initialize certificate store for signature validation";
            logger.error(errorMsg);
            throw new RuntimeException(errorMsg, e);
        }
        this.crypto = new MultiPartCryptoSigner(this.certificateStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCertificate(String kspath, String kspass, String alias) {
        Certificate cert;
        InputStream is = Utility.findResource(kspath);
        if (is == null) {
            throw new RuntimeException("Truststore " + kspath + " not found");
        }
        char[] keychars = kspass.toCharArray();
        try {
            KeyStore store = KeyStore.getInstance(this.keyStoreType);
            store.load(is, keychars);
            cert = store.getCertificate(alias);
        }
        catch (Exception e) {
            String errorMsg = FipsUtils.isFipsMode() ? "The keystore you are trying to use is not available in FIPS Mode. Consider using a BCFKS keystore" : "Error accessing truststore " + kspath;
            throw new RuntimeException(errorMsg, e);
        }
        if (cert == null) {
            throw new RuntimeException("No certificate found with alias " + alias + " in truststore " + kspath);
        }
        try {
            KeyStore e = this.certificateStore;
            synchronized (e) {
                this.certificateStore.setCertificateEntry(alias, cert);
            }
        }
        catch (KeyStoreException e) {
            throw new RuntimeException("Failed configuring certificate with alias " + alias + " to truststore", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCertificate(String alias) {
        try {
            KeyStore keyStore = this.certificateStore;
            synchronized (keyStore) {
                this.certificateStore.deleteEntry(alias);
            }
        }
        catch (KeyStoreException e) {
            throw new RuntimeException("Failed configuring certificate with alias " + alias + " to truststore", e);
        }
    }

    public boolean isSigned(MimeMultipart mimemp) {
        return this.crypto.isSigned(mimemp);
    }

    public MimeMultipart getSignedContent(MimeMultipart mimemp) {
        return this.crypto.getSignedContent(mimemp);
    }

    public List<MultiPartCryptoSigner.ValidationInformation> validateSignature(MimeMultipart mimemp) {
        return this.crypto.validateSignature(mimemp);
    }
}

