/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.rosettanet.extension.internal.rnif.delivery;

import com.mulesoft.connectors.rosettanet.extension.internal.xml.HeaderReader;
import java.io.InputStream;
import javax.xml.stream.XMLStreamException;

public class DeliveryReader
extends HeaderReader {
    private boolean secureTransportRequired;
    private String toBusinessIdentifier;
    private String toLocationIdentifier;
    private String fromBusinessIdentifier;
    private String fromLocationIdentifier;
    private String messageTrackingID;

    public DeliveryReader(InputStream is) throws XMLStreamException {
        super("DeliveryHeader", "DeliveryHeader_MS_V02_00.dtd", is);
    }

    @Override
    public void process() throws XMLStreamException {
        String secure = this.reader.readNested("isSecureTransportRequired", "AffirmationIndicator");
        if (secure.equals("Yes")) {
            this.secureTransportRequired = true;
        } else if (!secure.equals("No")) {
            throw new XMLStreamException("Invalid value for delivery header isSecureTransportRequired");
        }
        this.reader.closeElement();
        this.reader.readNested("messageDateTime", "DateTimeStamp");
        this.reader.closeElement();
        this.reader.openNested("messageReceiverIdentification", "PartnerIdentification");
        if (this.reader.checkElement("domain")) {
            this.reader.verifyNested("DUNS", "domain", "FreeFormText");
            this.reader.closeElement();
        }
        this.toBusinessIdentifier = this.reader.readElement("GlobalBusinessIdentifier");
        if (this.reader.checkElement("locationID")) {
            this.toLocationIdentifier = this.reader.readNested("locationID", "Value");
            this.reader.closeElement();
        }
        this.reader.closeNested(2);
        this.reader.openNested("messageSenderIdentification", "PartnerIdentification");
        if (this.reader.checkElement("domain")) {
            this.reader.verifyNested("DUNS", "domain", "FreeFormText");
            this.reader.closeElement();
        }
        this.fromBusinessIdentifier = this.reader.readElement("GlobalBusinessIdentifier");
        if (this.reader.checkElement("locationID")) {
            this.fromLocationIdentifier = this.reader.readNested("locationID", "Value");
            this.reader.closeElement();
        }
        this.reader.closeNested(2);
        this.messageTrackingID = this.reader.readNested("messageTrackingID", "InstanceIdentifier");
        this.reader.closeElement();
    }

    public boolean isSecureTransportRequired() {
        return this.secureTransportRequired;
    }

    public String getToBusinessIdentifier() {
        return this.toBusinessIdentifier;
    }

    public String getToLocationIdentifier() {
        return this.toLocationIdentifier;
    }

    public String getFromBusinessIdentifier() {
        return this.fromBusinessIdentifier;
    }

    public String getFromLocationIdentifier() {
        return this.fromLocationIdentifier;
    }

    public String getMessageTrackingID() {
        return this.messageTrackingID;
    }
}

