/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.rosettanet.extension.internal.rnif.delivery;

import com.mulesoft.connectors.rosettanet.extension.internal.config.RosettaNetConfig;
import com.mulesoft.connectors.rosettanet.extension.internal.xml.HeaderWriter;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.stream.XMLStreamException;

public class DeliveryWriter
extends HeaderWriter {
    private final String messageTrackingID;

    public DeliveryWriter(String id, OutputStream os, int indent) {
        super("DeliveryHeader", "DeliveryHeader_MS_V02_00.dtd", os, indent);
        this.messageTrackingID = id;
    }

    private void writePartner(String wrapper, String ident, String loc) throws XMLStreamException {
        this.writer.writeNested("DUNS", wrapper, "PartnerIdentification", "domain", "FreeFormText");
        this.writer.closeNested(1);
        this.writer.writeElement(ident, "GlobalBusinessIdentifier");
        if (loc != null) {
            this.writer.writeNested(loc, "locationID", "Value");
            this.writer.closeElement();
        }
        this.writer.closeNested(2);
    }

    @Override
    public void process(RosettaNetConfig config) throws XMLStreamException {
        String secure = config.getRequireSecureTransport() ? "Yes" : "No";
        this.writer.writeNested(secure, "isSecureTransportRequired", "AffirmationIndicator");
        this.writer.closeElement();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd'T'HHmmss.mmm'Z'");
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.writer.writeNested(format.format(new Date()), "messageDateTime", "DateTimeStamp");
        this.writer.closeElement();
        this.writePartner("messageReceiverIdentification", config.getPartnerBusinessIdentifier(), config.getPartnerLocationId());
        this.writePartner("messageSenderIdentification", config.getSelfBusinessIdentifier(), config.getSelfLocationId());
        this.writer.writeNested(this.messageTrackingID, "messageTrackingID", "InstanceIdentifier");
        this.writer.closeElement();
    }
}

