/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.rosettanet.extension.internal.rnif.service;

import com.mulesoft.connectors.rosettanet.extension.internal.xml.HeaderReader;
import java.io.InputStream;
import javax.xml.stream.XMLStreamException;

public class ServiceReader
extends HeaderReader {
    private String activityIdentifier;
    private String fromRole;
    private String fromService;
    private String replyActionIdentity;
    private String replyMsgId;
    private String actionIdentity;
    private String signalCode;
    private String signalVersion;
    private String toRole;
    private String toService;
    private String usageCode;
    private String pipCode;
    private String pipInstanceId;
    private String pipVersion;
    private String partnerBusinessIdentifier;
    private String partnerLocationID;

    public ServiceReader(InputStream is) throws XMLStreamException {
        super("ServiceHeader", "ServiceHeader_MS_V02_00.dtd", is);
    }

    private void readPartnerIdentification() throws XMLStreamException {
        this.reader.openElement("PartnerIdentification");
        if (this.reader.checkElement("domain")) {
            this.reader.verifyNested("DUNS", "domain", "FreeFormText");
            this.reader.closeElement();
        }
        this.partnerBusinessIdentifier = this.reader.readElement("GlobalBusinessIdentifier");
        if (this.reader.checkElement("locationID")) {
            this.partnerLocationID = this.reader.readNested("locationID", "Value");
            this.reader.closeElement();
        }
        this.reader.closeElement();
    }

    @Override
    public void process() throws XMLStreamException {
        this.activityIdentifier = this.reader.readNested("ProcessControl", "ActivityControl", "BusinessActivityIdentifier");
        this.fromRole = this.reader.readNested("MessageControl", "fromRole", "GlobalPartnerRoleClassificationCode");
        this.reader.closeElement();
        this.fromService = this.reader.readNested("fromService", "GlobalBusinessServiceCode");
        this.reader.closeElement();
        if (this.reader.checkElement("inReplyTo")) {
            this.replyActionIdentity = this.reader.readNested("inReplyTo", "ActionControl", "ActionIdentity", "GlobalBusinessActionCode");
            this.reader.closeElement();
            this.replyMsgId = this.reader.readNested("messageTrackingID", "InstanceIdentifier");
            this.reader.closeNested(3);
        }
        this.reader.openElement("Manifest");
        this.reader.skipOptionalElement("Attachment");
        this.reader.verifyNested("0", "numberOfAttachments", "CountableAmount");
        this.reader.closeElement();
        this.reader.openElement("ServiceContentControl");
        if (this.reader.checkElement("ActionIdentity")) {
            this.actionIdentity = this.reader.readNested("ActionIdentity", "GlobalBusinessActionCode");
            this.reader.skipOptionalElement("messageStandard");
            this.reader.skipOptionalElement("standardVersion");
        } else if (this.reader.checkElement("SignalIdentity")) {
            this.signalCode = this.reader.readNested("SignalIdentity", "GlobalBusinessSignalCode");
            this.signalVersion = this.reader.readElement("VersionIdentifier");
        } else {
            throw new IllegalStateException("Missing both ActionIdentity and SignalIdentity in ServiceContentControl");
        }
        this.reader.closeNested(3);
        this.toRole = this.reader.readNested("toRole", "GlobalPartnerRoleClassificationCode");
        this.reader.closeElement();
        this.toService = this.reader.readNested("toService", "GlobalBusinessServiceCode");
        this.reader.closeNested(3);
        this.usageCode = this.reader.readElement("GlobalUsageCode");
        this.reader.skipOptionalElement("partnerDefinedPIPPayloadBindingId");
        this.pipCode = this.reader.readNested("pipCode", "GlobalProcessIndicatorCode");
        this.reader.closeElement();
        this.pipInstanceId = this.reader.readNested("pipInstanceId", "InstanceIdentifier");
        this.reader.closeElement();
        this.pipVersion = this.reader.readNested("pipVersion", "VersionIdentifier");
        this.reader.closeElement();
        this.reader.skipOptionalElement("QualityOfServiceSpecification");
        if (this.reader.checkElement("KnownInitiatingPartner")) {
            this.reader.openElement("KnownInitiatingPartner");
            this.readPartnerIdentification();
        } else {
            this.reader.openElement("UnknownInitiatingPartner");
            this.readPartnerIdentification();
            this.reader.skipElement("UniformResourceLocator");
        }
        this.reader.closeNested(2);
    }

    public String getActivityIdentifier() {
        return this.activityIdentifier;
    }

    public String getFromRole() {
        return this.fromRole;
    }

    public String getFromService() {
        return this.fromService;
    }

    public String getActionIdentity() {
        return this.actionIdentity;
    }

    public String getSignalCode() {
        return this.signalCode;
    }

    public String getSignalVersion() {
        return this.signalVersion;
    }

    public String getReplyActionIdentity() {
        return this.replyActionIdentity;
    }

    public String getReplyMsgId() {
        return this.replyMsgId;
    }

    public String getToRole() {
        return this.toRole;
    }

    public String getToService() {
        return this.toService;
    }

    public String getUsageCode() {
        return this.usageCode;
    }

    public String getPipCode() {
        return this.pipCode;
    }

    public String getPipInstanceId() {
        return this.pipInstanceId;
    }

    public String getPipVersion() {
        return this.pipVersion;
    }

    public String getPartnerBusinessIdentifier() {
        return this.partnerBusinessIdentifier;
    }

    public String getPartnerLocationID() {
        return this.partnerLocationID;
    }
}

