/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.rosettanet.extension.internal.rnif.service;

import com.mulesoft.connectors.rosettanet.extension.api.config.PipRole;
import com.mulesoft.connectors.rosettanet.extension.internal.config.RosettaNetConfig;
import com.mulesoft.connectors.rosettanet.extension.internal.config.pip.ActionDetail;
import com.mulesoft.connectors.rosettanet.extension.internal.config.pip.PipDetail;
import com.mulesoft.connectors.rosettanet.extension.internal.xml.HeaderWriter;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;

public class ServiceWriter
extends HeaderWriter {
    private final String signalCode;
    private final String signalVersion;
    private final String replyActionIdentity;
    private final String replyMsgId;
    private final String pipInstance;

    public ServiceWriter(String sigCode, String sigVer, String replyAction, String replyId, String instance, OutputStream os, int indent) {
        super("ServiceHeader", "ServiceHeader_MS_V02_00.dtd", os, indent);
        if (sigCode == null && sigVer != null || sigCode != null && sigVer == null) {
            throw new IllegalArgumentException("Both signal code and signal version must be specified, or neither");
        }
        this.signalCode = sigCode;
        this.signalVersion = sigVer;
        this.replyActionIdentity = replyAction;
        this.replyMsgId = replyId;
        this.pipInstance = instance;
    }

    @Override
    public void process(RosettaNetConfig config) throws XMLStreamException {
        String initLoc;
        String initId;
        String toService;
        String toRole;
        String fromService;
        String fromRole;
        boolean initiator;
        PipDetail pip = config.getPipDetail();
        ActionDetail action = config.getSendAction();
        boolean bl = initiator = PipRole.INITIATOR == config.getPipRole();
        if (initiator) {
            fromRole = pip.getInitiatorPartnerRole();
            fromService = pip.getInitiatorServiceCode();
            toRole = pip.getResponderPartnerRole();
            toService = pip.getResponderServiceCode();
        } else {
            fromRole = pip.getResponderPartnerRole();
            fromService = pip.getResponderServiceCode();
            toRole = pip.getInitiatorPartnerRole();
            toService = pip.getInitiatorServiceCode();
        }
        this.writer.writeNested(pip.getActivityIdentifier(), "ProcessControl", "ActivityControl", "BusinessActivityIdentifier");
        this.writer.writeNested(fromRole, "MessageControl", "fromRole", "GlobalPartnerRoleClassificationCode");
        this.writer.closeElement();
        this.writer.writeNested(fromService, "fromService", "GlobalBusinessServiceCode");
        this.writer.closeElement();
        if (this.replyActionIdentity != null || this.replyMsgId != null) {
            if (this.replyActionIdentity == null || this.replyMsgId == null) {
                throw new IllegalArgumentException("Need both action identity and reply message id");
            }
            this.writer.writeNested(this.replyActionIdentity, "inReplyTo", "ActionControl", "ActionIdentity", "GlobalBusinessActionCode");
            this.writer.closeElement();
            this.writer.writeNested(this.replyMsgId, "messageTrackingID", "InstanceIdentifier");
            this.writer.closeNested(3);
        }
        this.writer.writeNested("0", "Manifest", "numberOfAttachments", "CountableAmount");
        this.writer.closeElement();
        this.writer.openElement("ServiceContentControl");
        if (this.signalCode == null) {
            this.writer.writeNested(action.getActionCode(), "ActionIdentity", "GlobalBusinessActionCode");
        } else {
            this.writer.writeNested(this.signalCode, "SignalIdentity", "GlobalBusinessSignalCode");
            this.writer.writeElement(this.signalVersion, "VersionIdentifier");
        }
        this.writer.closeNested(3);
        this.writer.writeNested(toRole, "toRole", "GlobalPartnerRoleClassificationCode");
        this.writer.closeElement();
        this.writer.writeNested(toService, "toService", "GlobalBusinessServiceCode");
        this.writer.closeNested(3);
        this.writer.writeElement(config.getGlobalUsageCode().name(), "GlobalUsageCode");
        this.writer.writeNested(pip.getPipCode(), "pipCode", "GlobalProcessIndicatorCode");
        this.writer.closeElement();
        this.writer.writeNested(this.pipInstance, "pipInstanceId", "InstanceIdentifier");
        this.writer.closeElement();
        this.writer.writeNested(pip.getPipVersion(), "pipVersion", "VersionIdentifier");
        this.writer.closeElement();
        this.writer.writeNested("DUNS", "KnownInitiatingPartner", "PartnerIdentification", "domain", "FreeFormText");
        this.writer.closeElement();
        if (initiator) {
            initId = config.getSelfBusinessIdentifier();
            initLoc = config.getSelfLocationId();
        } else {
            initId = config.getPartnerBusinessIdentifier();
            initLoc = config.getPartnerLocationId();
        }
        this.writer.writeElement(initId, "GlobalBusinessIdentifier");
        if (initLoc != null) {
            this.writer.writeNested(initLoc, "locationID", "Value");
            this.writer.closeElement();
        }
        this.writer.closeNested(3);
    }
}

