/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.rosettanet.extension.internal.send;

import com.mulesoft.connectors.rosettanet.extension.api.config.ForceSigning;
import com.mulesoft.connectors.rosettanet.extension.internal.MimeData;
import com.mulesoft.connectors.rosettanet.extension.internal.Utility;
import com.mulesoft.connectors.rosettanet.extension.internal.config.RosettaNetConfig;
import com.mulesoft.connectors.rosettanet.extension.internal.rnif.MimeMessageBuilder;
import com.mulesoft.connectors.rosettanet.extension.internal.rnif.MimeUtils;
import com.mulesoft.connectors.rosettanet.extension.internal.rnif.RosettaData;
import com.mulesoft.connectors.rosettanet.extension.internal.rnif.acknowledge.AcknowledgmentWriter;
import com.mulesoft.connectors.rosettanet.extension.internal.send.SendOperation;
import java.io.ByteArrayOutputStream;
import javax.mail.internet.MimeMultipart;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendAcknowledgment
extends SendOperation {
    private static final Logger logger = LoggerFactory.getLogger(SendAcknowledgment.class);
    private final RosettaNetConfig connectorConfig;
    private final MimeData mimeData;

    public SendAcknowledgment(MimeMessageBuilder builder, boolean sign, RosettaNetConfig config, String replyAction, String replyId, String instance, byte[] digest) {
        super(config.getRequesterConfigName(), config.getRequestPath(), config.getExtClient(), config.getRequireSecureTransport());
        this.connectorConfig = config;
        ForceSigning override = config.getSigningOverride();
        this.mimeData = this.buildMimeData(digest, override == null ? sign : override.isSigned(), replyAction, replyId, instance, builder);
    }

    private MimeData buildMimeData(byte[] digest, boolean sign, String replyActionIdentity, String replyMsgId, String pipInstance, MimeMessageBuilder messageBuilder) {
        RosettaData rdata;
        try {
            String digestText = digest == null ? null : DatatypeConverter.printBase64Binary((byte[])digest);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            AcknowledgmentWriter writer = new AcknowledgmentWriter(bos, 1, digestText);
            writer.write(this.connectorConfig);
            logger.debug("Generated acknowledgment message: " + new String(bos.toByteArray(), Utility.CHARSET_UTF8));
            rdata = messageBuilder.buildSignalMessage(sign, "Receipt Acknowledgment", "V02.00", replyActionIdentity, replyMsgId, pipInstance, this.connectorConfig, bos.toByteArray());
        }
        catch (Exception e) {
            String text = "Error generating MIME data for acknowledgment message to endpoint " + this.connectorConfig.getRequesterConfigName();
            logger.error(text, (Throwable)e);
            throw new RuntimeException(text, e);
        }
        logger.debug("Sending acknowledgment message to endpoint  " + this.connectorConfig.getRequesterConfigName() + "]");
        return MimeUtils.buildMimeData((boolean)sign, (MimeMultipart)rdata.getMimeMultipart());
    }

    public byte[] getMimeBytes() {
        return this.mimeData.getBody();
    }

    @Override
    public void run() {
        logger.debug("Sending acknowledgment message to endpoint  " + this.connectorConfig.getRequesterConfigName() + "]");
        this.send(this.mimeData);
    }
}

