/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.rosettanet.extension.internal.send;

import com.mulesoft.connectors.rosettanet.extension.api.config.ForceSigning;
import com.mulesoft.connectors.rosettanet.extension.internal.config.RosettaNetConfig;
import com.mulesoft.connectors.rosettanet.extension.internal.rnif.MimeMessageBuilder;
import com.mulesoft.connectors.rosettanet.extension.internal.rnif.MimeUtils;
import com.mulesoft.connectors.rosettanet.extension.internal.rnif.RosettaData;
import com.mulesoft.connectors.rosettanet.extension.internal.rnif.exception.ExceptionWriter;
import com.mulesoft.connectors.rosettanet.extension.internal.send.SendOperation;
import java.io.ByteArrayOutputStream;
import javax.mail.internet.MimeMultipart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendException
extends SendOperation {
    private static final Logger logger = LoggerFactory.getLogger(SendException.class);
    private final RosettaNetConfig connectorConfig;
    private final MimeMessageBuilder messageBuilder;
    private final boolean signMessage;
    private final String replyActionIdentity;
    private final String replyMsgId;
    private final String pipInstance;
    private final String exceptionType;
    private final String exceptionCode;
    private final String freeFormText;
    private final String componentCode;

    public SendException(MimeMessageBuilder builder, boolean sign, RosettaNetConfig config, String replyAction, String replyId, String instance, String type, String code, String text, String comp) {
        super(config.getRequesterConfigName(), config.getRequestPath(), config.getExtClient(), config.getRequireSecureTransport());
        this.connectorConfig = config;
        this.messageBuilder = builder;
        ForceSigning override = config.getSigningOverride();
        this.signMessage = override == null ? sign : override.isSigned();
        this.replyActionIdentity = replyAction;
        this.replyMsgId = replyId;
        this.pipInstance = instance;
        this.exceptionType = type;
        this.exceptionCode = code;
        this.freeFormText = text;
        this.componentCode = comp;
    }

    @Override
    public void run() {
        RosettaData rdata;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ExceptionWriter writer = new ExceptionWriter(this.exceptionType, this.exceptionCode, this.freeFormText, this.componentCode, bos, 1);
            writer.write(this.connectorConfig);
            rdata = this.messageBuilder.buildSignalMessage(this.signMessage, "Exception", "V02.00", this.replyActionIdentity, this.replyMsgId, this.pipInstance, this.connectorConfig, bos.toByteArray());
        }
        catch (Exception e) {
            String text = "Error generating MIME data for exception message to endpoint [" + this.connectorConfig.getRequesterConfigName() + "]";
            logger.error(text, (Throwable)e);
            throw new RuntimeException(text, e);
        }
        logger.debug("Sending exception message to endpoint [" + this.connectorConfig.getRequesterConfigName() + "]");
        this.send(MimeUtils.buildMimeData((boolean)this.signMessage, (MimeMultipart)rdata.getMimeMultipart()));
    }
}

