/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.rosettanet.extension.internal.send;

import com.mulesoft.connectors.rosettanet.extension.internal.MimeData;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.client.DefaultOperationParameters;
import org.mule.runtime.extension.api.client.ExtensionsClient;
import org.mule.runtime.extension.api.client.OperationParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SendOperation
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(SendOperation.class);
    protected final String requesterConfigName;
    protected final String requestPath;
    private final ExtensionsClient extensionsClient;
    private final boolean requireSecureTransport;

    public SendOperation(String reqName, String path, ExtensionsClient client, boolean requireSecure) {
        this.requesterConfigName = reqName;
        this.requestPath = path;
        this.extensionsClient = client;
        this.requireSecureTransport = requireSecure;
    }

    private OperationParameters buildParams(MimeData data) {
        MultiMap headers = new MultiMap();
        String[] mimeheads = data.getHeaders();
        mimeheads = mimeheads == null ? new String[]{} : mimeheads;
        for (int i = 0; i < mimeheads.length; i += 2) {
            headers.put((Object)mimeheads[i], (Object)mimeheads[i + 1]);
        }
        headers.put((Object)"x-RN-Version", (Object)"RosettaNet/V02.00");
        headers.put((Object)"x-RN-Response-Type", (Object)"async");
        return DefaultOperationParameters.builder().configName(this.requesterConfigName).addParameter("method", (Object)"POST").addParameter("headers", (Object)headers).addParameter("path", (Object)this.requestPath).addParameter("body", (Object)new TypedValue((Object)data.getBody(), DataType.BYTE_ARRAY)).build();
    }

    protected void send(MimeData data) {
        String lower;
        if (this.requireSecureTransport && this.requestPath != null && (lower = this.requestPath.toLowerCase()).startsWith("http://")) {
            throw new RuntimeException("Secure transport required but outbound request path is not HTTPS");
        }
        OperationParameters params = this.buildParams(data);
        this.extensionsClient.executeAsync("HTTP", "request", params).whenComplete((response, exception) -> {
            if (response != null) {
                logger.debug("Send succeeded to endpoint [" + this.requesterConfigName + "]");
            } else {
                logger.debug("Exception sending to endpoint [" + this.requesterConfigName + "]", exception);
            }
        });
    }
}

