/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.rosettanet.extension.internal.xml;

import com.ctc.wstx.stax.WstxInputFactory;
import com.mulesoft.connectors.rosettanet.extension.internal.Utility;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.stax2.XMLStreamReader2;
import org.codehaus.stax2.util.StreamReader2Delegate;
import org.codehaus.stax2.validation.XMLValidationSchema;
import org.codehaus.stax2.validation.XMLValidationSchemaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentRewriter
extends StreamReader2Delegate
implements XMLStreamConstants {
    private static final Logger logger = LoggerFactory.getLogger(DocumentRewriter.class);
    private final String dtdName;
    private final String dtdIdent;
    private final OutputStream outStream;
    private boolean startDocument;
    private XMLStreamWriter writer;

    public DocumentRewriter(InputStream in, String name, String ident, String path, OutputStream os) throws IOException, XMLStreamException {
        super(DocumentRewriter.getReader(in, ident, path));
        logger.debug("DocumentRewriter created with name=" + name + ", ident=" + ident + ", and path=" + path);
        this.dtdName = name;
        this.dtdIdent = ident;
        this.outStream = os;
    }

    private static XMLStreamReader2 getReader(InputStream in, String ident, String path) throws IOException, XMLStreamException {
        WstxInputFactory inFactory = new WstxInputFactory();
        inFactory.setProperty("javax.xml.stream.isValidating", (Object)Boolean.TRUE);
        inFactory.setProperty("javax.xml.stream.supportDTD", (Object)Boolean.TRUE);
        String dtdPath = path + ident;
        InputStream is = Utility.findResource(dtdPath);
        if (is == null) {
            throw new XMLStreamException("Unable to access DTD at path " + dtdPath);
        }
        final byte[] dtddata = Utility.readFully(is);
        XMLResolver resolver = new XMLResolver(){

            @Override
            public Object resolveEntity(String publicID, String systemID, String baseURI, String namespace) {
                return new ByteArrayInputStream(dtddata);
            }
        };
        inFactory.setXMLResolver(resolver);
        XMLStreamReader2 reader = (XMLStreamReader2)inFactory.createXMLStreamReader(in);
        XMLValidationSchemaFactory schemaFactory = XMLValidationSchemaFactory.newInstance((String)"http://www.w3.org/XML/1998/namespace", (ClassLoader)DocumentRewriter.class.getClassLoader());
        XMLValidationSchema schema = schemaFactory.createSchema((InputStream)new ByteArrayInputStream(dtddata));
        reader.validateAgainst(schema);
        return reader;
    }

    public int next() throws XMLStreamException {
        int code = super.next();
        if (!this.startDocument) {
            while (code == 5) {
                code = super.next();
            }
            String version = "1.0";
            String encoding = "UTF-8";
            if (code == 7) {
                version = this.getVersion();
                encoding = this.getEncoding();
            }
            XMLOutputFactory factory = XMLOutputFactory.newInstance();
            this.writer = factory.createXMLStreamWriter(this.outStream, encoding);
            this.writer.writeStartDocument(encoding, version);
            this.writer.writeCharacters("\n");
            if (this.dtdName != null) {
                this.writer.writeDTD("<!DOCTYPE " + this.dtdName + " SYSTEM \"" + this.dtdIdent + "\">");
                this.writer.writeCharacters("\n");
            }
            this.startDocument = true;
        }
        switch (code) {
            case 12: {
                this.writer.writeCData(this.getText());
                break;
            }
            case 4: 
            case 6: {
                this.writer.writeCharacters(this.getText());
                break;
            }
            case 8: {
                this.writer.writeEndDocument();
                break;
            }
            case 2: {
                this.writer.writeEndElement();
                break;
            }
            case 1: {
                this.writer.writeStartElement(this.getPrefixedName());
                int count = this.getAttributeCount();
                for (int i = 0; i < count; ++i) {
                    if (!this.isAttributeSpecified(i)) continue;
                    String name = this.getAttributeLocalName(i);
                    String uri = this.getAttributeNamespace(i);
                    String prefix = this.getAttributePrefix(i);
                    String value = this.getAttributeValue(i);
                    this.writer.writeAttribute(prefix, uri, name, value);
                }
                break;
            }
        }
        return code;
    }

    public void rewrite() throws XMLStreamException {
        while (this.hasNext()) {
            this.next();
        }
        logger.debug("DocumentRewriter rewrite() completed");
    }
}

