/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.rosettanet.extension.internal.xml;

import com.mulesoft.connectors.rosettanet.extension.internal.Utility;
import com.mulesoft.connectors.rosettanet.extension.internal.xml.WrappedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HeaderReader {
    private static final Logger logger = LoggerFactory.getLogger(HeaderReader.class);
    private final String rootElement;
    private final String systemIdent;
    protected final WrappedReader reader;

    public HeaderReader(String root, String ident, InputStream is) throws XMLStreamException {
        this.rootElement = root;
        this.systemIdent = ident;
        try {
            byte[] data = Utility.readFully(is);
            if (logger.isTraceEnabled()) {
                logger.trace("HeaderReader verifying:\n" + new String(data, "UTF-8"));
            }
            this.reader = new WrappedReader(new ByteArrayInputStream(data));
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    protected abstract void process() throws XMLStreamException;

    public void read() throws XMLStreamException {
        this.reader.init(this.rootElement);
        this.reader.openElement(this.rootElement);
        this.process();
        this.reader.closeElement();
        List<WrappedReader.ErrorInfo> errors = this.reader.getErrorList();
        if (errors.size() > 0) {
            StringBuilder builder = new StringBuilder();
            for (WrappedReader.ErrorInfo info : errors) {
                builder.append("\n ");
                builder.append(info.getErrorText());
                builder.append(" at element number ");
                builder.append(info.getElementNumber());
                builder.append(" (" + info.getElementName() + ")");
            }
            throw new XMLStreamException("Errors processing " + this.rootElement + " message data:" + builder.toString());
        }
    }

    public List<WrappedReader.ErrorInfo> getErrorList() {
        return this.reader.getErrorList();
    }
}

