/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.rosettanet.extension.internal.xml;

import com.ctc.wstx.stax.WstxInputFactory;
import com.mulesoft.connectors.rosettanet.extension.internal.Utility;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WrappedReader {
    private static final Logger logger = LoggerFactory.getLogger(WrappedReader.class);
    private static final String DOCTYPE_LEAD = "<!DOCTYPE ";
    private static final String DTD_DIRECTORY = "/RNIF_V02_00_01/";
    private final XMLStreamReader reader;
    private final List<ErrorInfo> errorList;
    private boolean readerAdvanced;
    private int elementNumber;
    private String elementName;

    public WrappedReader(InputStream is) throws XMLStreamException {
        WstxInputFactory factory = new WstxInputFactory();
        factory.setProperty("javax.xml.stream.isValidating", Boolean.TRUE);
        factory.setProperty("javax.xml.stream.supportDTD", Boolean.TRUE);
        factory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.FALSE);
        XMLResolver resolver = new XMLResolver(){

            @Override
            public Object resolveEntity(String publicID, String systemID, String baseURI, String namespace) throws XMLStreamException {
                InputStream in = Utility.findResource(WrappedReader.DTD_DIRECTORY + systemID);
                if (in == null) {
                    throw new XMLStreamException("DTD " + systemID + " not found");
                }
                return in;
            }
        };
        factory.setXMLResolver(resolver);
        this.reader = factory.createXMLStreamReader(is);
        this.errorList = new ArrayList<ErrorInfo>();
    }

    public void init(String type) throws XMLStreamException {
        block5: while (true) {
            int code = this.reader.next();
            switch (code) {
                case 7: {
                    String version = this.reader.getVersion();
                    if (version != null && !version.equals("1.0")) {
                        throw new XMLStreamException("Unsupported XML version " + version);
                    }
                    String encoding = this.reader.getEncoding();
                    if (encoding == null) break;
                    String upper = encoding.toUpperCase();
                    if (upper.equals("UTF-8") || upper.equals("UTF-16")) continue block5;
                    throw new XMLStreamException("Invalid character encoding " + encoding);
                }
                case 11: {
                    String tail;
                    int split;
                    String text = this.reader.getText();
                    if (text.startsWith(DOCTYPE_LEAD) && (split = (tail = text.substring(DOCTYPE_LEAD.length()).trim()).indexOf(32)) > 0) {
                        String name = tail.substring(0, split);
                        if (type.equals(name)) {
                            return;
                        }
                        throw new XMLStreamException("Document Type Definition name " + name + " when " + type + " expected");
                    }
                    return;
                }
                case 1: {
                    throw new XMLStreamException("Document missing required Document Type Definition");
                }
            }
        }
    }

    public void validate() throws XMLStreamException {
        while (true) {
            int code = this.reader.next();
            switch (code) {
                case 8: {
                    return;
                }
            }
        }
    }

    public List<ErrorInfo> getErrorList() {
        return this.errorList;
    }

    private int nextTag() throws XMLStreamException {
        if (!this.readerAdvanced) {
            int type;
            while ((type = this.reader.next()) != 2 && type != 1) {
            }
        }
        this.readerAdvanced = false;
        int code = this.reader.getEventType();
        if (1 == code) {
            ++this.elementNumber;
            this.elementName = this.reader.getLocalName();
        }
        return code;
    }

    private String openElement() throws XMLStreamException {
        if (this.nextTag() == 1) {
            return this.reader.getLocalName();
        }
        throw new XMLStreamException("Expected start tag, found " + this.reader.getLocalName() + " end tag");
    }

    public boolean checkElement(String name) throws XMLStreamException {
        int code;
        if (!this.readerAdvanced) {
            this.reader.nextTag();
            this.readerAdvanced = true;
        }
        if (1 == (code = this.reader.getEventType())) {
            return this.reader.getLocalName().equals(name);
        }
        return false;
    }

    public void openElement(String name) throws XMLStreamException {
        String found = this.openElement();
        if (!name.equals(found)) {
            throw new XMLStreamException("Expected " + name + " start tag, found " + found + " start tag");
        }
    }

    public void openNested(String ... names) throws XMLStreamException {
        for (int i = 0; i < names.length; ++i) {
            this.openElement(names[i]);
        }
    }

    private void skipOpenElement() throws XMLStreamException {
        int depth = 1;
        while (depth > 0) {
            switch (this.nextTag()) {
                case 1: {
                    ++depth;
                    break;
                }
                case 2: {
                    --depth;
                }
            }
        }
    }

    public void closeElement() throws XMLStreamException {
        int code = this.nextTag();
        if (code == 1) {
            ErrorInfo info = new ErrorInfo("Unexpected content found starting with " + this.reader.getLocalName() + "element", this.elementName, this.elementNumber);
            logger.error(info.toString());
            this.errorList.add(info);
            while (code == 1) {
                this.skipOpenElement();
                code = this.nextTag();
            }
        }
    }

    public void closeNested(int count) throws XMLStreamException {
        for (int i = 0; i < count; ++i) {
            this.closeElement();
        }
    }

    public void skipElement(String name) throws XMLStreamException {
        this.openElement(name);
        this.skipOpenElement();
    }

    public void skipOptionalElement(String name) throws XMLStreamException {
        if (this.checkElement(name)) {
            this.skipElement(name);
        }
    }

    public String readElement(String name) throws XMLStreamException {
        this.openElement(name);
        return this.reader.getElementText().trim();
    }

    public String readNested(String ... names) throws XMLStreamException {
        this.openNested(names);
        String value = this.reader.getElementText().trim();
        if (value == "") {
            return null;
        }
        return value;
    }

    private void verifyValue(String expect, String actual) {
        if (expect != null && expect.length() > 0 && !expect.equals(actual)) {
            ErrorInfo info = new ErrorInfo("Expected content '" + expect + "', found '" + actual + "'", this.elementName, this.elementNumber);
            logger.error(info.toString());
            this.errorList.add(info);
        }
    }

    public void verifyElement(String value, String name) throws XMLStreamException {
        this.verifyValue(value, this.readElement(name));
    }

    public void verifyNested(String value, String ... names) throws XMLStreamException {
        this.verifyValue(value, this.readNested(names));
    }

    public static class ErrorInfo {
        private final String errorText;
        private final String elementName;
        private final int elementNumber;

        public ErrorInfo(String text, String lname, int number) {
            this.errorText = text;
            this.elementName = lname;
            this.elementNumber = number;
        }

        public String getErrorText() {
            return this.errorText;
        }

        public String getElementName() {
            return this.elementName;
        }

        public int getElementNumber() {
            return this.elementNumber;
        }

        public String toString() {
            return this.errorText + " at element number " + this.elementNumber + " (" + this.elementName + ")";
        }
    }
}

