/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.rosettanet.extension.internal.xml;

import java.io.OutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class WrappedWriter {
    private final XMLStreamWriter writer;
    private final int indentCount;
    private final String indentText;
    private int nestingDepth;

    public WrappedWriter(OutputStream os, int indent) throws XMLStreamException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        this.writer = factory.createXMLStreamWriter(os, "UTF-8");
        StringBuilder builder = new StringBuilder();
        this.indentCount = indent;
        for (int i = 0; i < indent; ++i) {
            builder.append(' ');
        }
        this.indentText = builder.toString();
    }

    public void init(String name, String ident) throws XMLStreamException {
        this.writer.writeStartDocument("UTF-8", "1.0");
        if (this.indentCount >= 0) {
            this.writer.writeCharacters("\n");
        }
        this.writer.writeDTD("<!DOCTYPE " + name + " SYSTEM \"" + ident + "\">");
    }

    public void term() throws XMLStreamException {
        this.writer.writeEndDocument();
    }

    private void indent() throws XMLStreamException {
        if (this.indentCount >= 0) {
            StringBuilder builder = new StringBuilder();
            builder.append('\n');
            for (int i = 0; i < this.nestingDepth; ++i) {
                builder.append(this.indentText);
            }
            this.writer.writeCharacters(builder.toString());
        }
    }

    public void openElement(String name) throws XMLStreamException {
        this.indent();
        this.writer.writeStartElement(name);
        ++this.nestingDepth;
    }

    public void writeElement(String text, String name) throws XMLStreamException {
        this.indent();
        this.writer.writeStartElement(name);
        this.writer.writeCharacters(text);
        this.writer.writeEndElement();
    }

    public void closeElement() throws XMLStreamException {
        --this.nestingDepth;
        this.indent();
        this.writer.writeEndElement();
    }

    public void writeNested(String text, String ... names) throws XMLStreamException {
        int length = names.length;
        for (int i = 0; i < length - 1; ++i) {
            this.openElement(names[i]);
        }
        this.writeElement(text, names[length - 1]);
    }

    public void closeNested(int count) throws XMLStreamException {
        for (int i = 0; i < count; ++i) {
            this.closeElement();
        }
    }
}

