/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.sap.extension.internal.config;

import java.nio.charset.Charset;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.DefaultEncoding;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SapInboundConfigAdvanced {
    private static final Logger logger = LoggerFactory.getLogger(SapInboundConfigAdvanced.class);
    private static final String DEFAULT_ENCODING = "UTF-8";
    @DefaultEncoding
    private String muleEncoding;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced", order=2)
    @Example(value="UTF-8")
    @Summary(value="Canonical name of encoding. More details about supported encodings at: https://docs.oracle.com/javase/7/docs/technotes/guides/intl/encoding.doc.html")
    private String encoding;

    public String getEncoding() {
        String enc;
        String string = enc = StringUtils.isEmpty((String)this.muleEncoding) ? DEFAULT_ENCODING : this.muleEncoding;
        if (StringUtils.isEmpty((String)this.encoding)) {
            return enc;
        }
        try {
            Charset.forName(this.encoding);
            return this.encoding;
        }
        catch (Exception exc) {
            logger.error("Invalid encoding '{}' found in configuration parameters! Reverted to default encoding '{}'! More details about supported encodings at: https://docs.oracle.com/javase/7/docs/technotes/guides/intl/encoding.doc.html\"", (Object)this.encoding, (Object)enc);
            return enc;
        }
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }
}

