/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.sap.extension.internal.connection;

import com.sap.conn.jco.JCo;
import com.sap.conn.jco.JCoContext;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoDestinationManager;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoTraceListener;
import java.io.Closeable;
import org.mule.connectors.commons.template.connection.ConnectorConnection;
import org.mule.modules.sap.extension.internal.connection.SapJCoTraceListener;
import org.mule.modules.sap.extension.internal.exception.business.BusinessObjectExecutionException;
import org.mule.modules.sap.extension.internal.exception.business.MissingBusinessObjectException;
import org.mule.modules.sap.extension.internal.exception.config.InvalidConfigurationException;
import org.mule.modules.sap.extension.internal.exception.config.InvalidCredentialsException;
import org.mule.modules.sap.extension.internal.exception.config.InvalidDestinationException;
import org.mule.modules.sap.extension.internal.exception.config.InvalidHostException;
import org.mule.modules.sap.extension.internal.exception.config.UnknownInvalidDestinationException;
import org.mule.modules.sap.extension.internal.exception.transaction.CommitFunctionRetrievalException;
import org.mule.modules.sap.extension.internal.exception.transaction.ConfirmTransactionException;
import org.mule.modules.sap.extension.internal.exception.transaction.RollbackFunctionRetrievalException;
import org.mule.modules.sap.extension.internal.exception.transaction.SapTransactionException;
import org.mule.modules.sap.extension.internal.service.JCoFunctionDAO;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.extension.api.connectivity.TransactionalConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SapConnection
implements TransactionalConnection,
Closeable,
ConnectorConnection {
    private static final Logger logger = LoggerFactory.getLogger(SapConnection.class);
    private static final SapJCoTraceListener traceListener = new SapJCoTraceListener();
    private final JCoDestination destination;
    private final JCoFunctionDAO jCoFunctionDAO;

    public SapConnection(String destinationName) throws ConnectionException {
        try {
            this.destination = JCoDestinationManager.getDestination((String)String.format("%1.127s", destinationName));
            this.jCoFunctionDAO = new JCoFunctionDAO(this.destination, true);
        }
        catch (JCoException e) {
            InvalidDestinationException thrownException;
            switch (e.getKey()) {
                case "JCO_ERROR_LOGON_FAILURE": {
                    thrownException = new InvalidCredentialsException(e);
                    break;
                }
                case "JCO_ERROR_COMMUNICATION": {
                    thrownException = new InvalidHostException(e);
                    break;
                }
                case "JCO_ERROR_CONFIGURATION": {
                    thrownException = new InvalidConfigurationException(e);
                    break;
                }
                default: {
                    thrownException = new UnknownInvalidDestinationException(e);
                }
            }
            throw new ConnectionException((Throwable)thrownException);
        }
    }

    public void begin() throws TransactionException {
        JCoContext.begin((JCoDestination)this.destination);
    }

    public void commit() throws TransactionException {
        try {
            JCoFunction commitFunction = this.jCoFunctionDAO.getFunction("BAPI_TRANSACTION_COMMIT");
            commitFunction.getImportParameterList().setValue("WAIT", "X");
            logger.debug("Commiting without TID");
            this.jCoFunctionDAO.executeSynchronousRFC(commitFunction);
        }
        catch (BusinessObjectExecutionException | MissingBusinessObjectException e) {
            throw new CommitFunctionRetrievalException(e);
        }
        catch (JCoException e) {
            throw new ConfirmTransactionException(e);
        }
        finally {
            this.end();
        }
    }

    public void rollback() throws TransactionException {
        try {
            JCoFunction rollbackFunction = this.jCoFunctionDAO.getFunction("BAPI_TRANSACTION_ROLLBACK");
            this.jCoFunctionDAO.executeSynchronousRFC(rollbackFunction);
        }
        catch (BusinessObjectExecutionException | MissingBusinessObjectException e) {
            throw new RollbackFunctionRetrievalException(e);
        }
        catch (JCoException e) {
            throw new ConfirmTransactionException(e);
        }
        finally {
            this.end();
        }
    }

    @Override
    public void close() {
        JCo.removeTraceListener((JCoTraceListener)traceListener);
    }

    public String getKey() {
        return this.destination.getDestinationName();
    }

    public void disconnect() {
        this.close();
    }

    public void validate() {
        try {
            this.destination.ping();
        }
        catch (JCoException e) {
            InvalidDestinationException result;
            switch (e.getKey()) {
                case "JCO_ERROR_LOGON_FAILURE": {
                    result = new InvalidCredentialsException(e);
                    break;
                }
                case "JCO_ERROR_COMMUNICATION": {
                    result = new InvalidHostException(e);
                    break;
                }
                case "JCO_ERROR_CONFIGURATION": {
                    result = new InvalidConfigurationException(e);
                    break;
                }
                default: {
                    result = new UnknownInvalidDestinationException(e);
                }
            }
            throw result;
        }
    }

    private void end() throws SapTransactionException {
        try {
            JCoContext.end((JCoDestination)this.destination);
        }
        catch (JCoException e) {
            throw new ConfirmTransactionException(e);
        }
    }

    public String toString() {
        return this.destination.getDestinationName();
    }
}

