/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.sap.extension.internal.connection;

import com.sap.conn.jco.JCo;
import com.sap.conn.jco.ext.DestinationDataProvider;
import com.sap.conn.jco.ext.Environment;
import com.sap.conn.jco.ext.ServerDataProvider;
import com.sap.conn.jco.rt.JCoRuntimeFactory;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import org.mule.modules.sap.extension.internal.connection.SapJCoDataProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SapEnvironment {
    private static final Logger logger = LoggerFactory.getLogger(SapEnvironment.class);
    private static SapEnvironment instance = new SapEnvironment();

    private SapEnvironment() {
    }

    public static SapEnvironment getInstance() {
        return instance;
    }

    public synchronized void startup() {
        SapJCoDataProvider dataProvider = SapJCoDataProvider.getInstance();
        if (!Environment.isDestinationDataProviderRegistered()) {
            Environment.registerDestinationDataProvider((DestinationDataProvider)dataProvider);
            logger.info("Destination data connection registered. Implementation class is: {}", dataProvider.getClass());
        } else {
            logger.info("There is an existing destination data connection registered.");
        }
        if (!Environment.isServerDataProviderRegistered()) {
            Environment.registerServerDataProvider((ServerDataProvider)dataProvider);
            logger.info("Server data connection registered. Implementation class is: {}", dataProvider.getClass());
        } else {
            logger.info("There is an existing server data connection registered.");
        }
    }

    public void shutdown() {
        boolean isShutDown;
        ClassLoader transportClassLoader = SapEnvironment.class.getClassLoader();
        ClassLoader jcoClassLoader = JCo.class.getClassLoader();
        ClassLoader environmentClassLoader = Environment.class.getClassLoader();
        if (transportClassLoader == jcoClassLoader && jcoClassLoader == environmentClassLoader) {
            if (Boolean.getBoolean("mule.studio")) {
                logger.debug("Running inside Studio DataSense classloader. Avoiding JCo classloader leaks.");
                isShutDown = true;
            } else {
                boolean isApplicationClassloader = false;
                try {
                    isApplicationClassloader = Class.forName("org.mule.module.launcher.application.ApplicationClassLoader").isInstance(transportClassLoader);
                }
                catch (ClassNotFoundException ex) {
                    logger.info("Application classloader not found");
                    logger.trace("Exception information.", (Throwable)ex);
                }
                if (isApplicationClassloader) {
                    logger.debug("Running inside Mule ESB application classloader. Avoiding JCo classloader leaks.");
                    isShutDown = true;
                } else {
                    logger.debug("Running with classloader {}.", (Object)transportClassLoader.getClass().getName());
                    isShutDown = false;
                }
            }
        } else {
            logger.warn("SAP components located in different classloaders. Mule SAP Transport and JCo libraries should go in the same directory/classloader.");
            logger.debug("Transport classloader: {} - JCo classloader: {} - JCo Environment classloader: {}", new Object[]{transportClassLoader.getClass().getName(), jcoClassLoader.getClass().getName(), environmentClassLoader});
            isShutDown = false;
        }
        if (isShutDown) {
            SapJCoDataProvider dataProvider = SapJCoDataProvider.getInstance();
            if (Environment.isDestinationDataProviderRegistered()) {
                try {
                    Environment.unregisterDestinationDataProvider((DestinationDataProvider)dataProvider);
                    logger.info("Destination data connection unregistered. Implementation class is: {}", dataProvider.getClass());
                }
                catch (RuntimeException ex) {
                    logger.error("Could not unregister destination data connection", (Throwable)ex);
                }
            } else {
                logger.info("There is no existing destination data connection registered.");
            }
            if (Environment.isServerDataProviderRegistered()) {
                try {
                    Environment.unregisterServerDataProvider((ServerDataProvider)dataProvider);
                    logger.info("Server data connection unregistered. Implementation class is: {}", dataProvider.getClass());
                }
                catch (RuntimeException ex) {
                    logger.error("Could not unregister destination data connection", (Throwable)ex);
                }
            } else {
                logger.info("There is no existing server data connection registered.");
            }
            SapJCoDataProvider.getInstance().clear();
            Thread.getAllStackTraces().keySet().stream().filter(input -> Optional.ofNullable(input).map(Thread::getName).map(name -> name.equals("JCoTimeoutChecker")).orElse(false)).forEach(t -> {
                try {
                    Field declaredField = Thread.class.getDeclaredField("target");
                    declaredField.setAccessible(true);
                    Object autoJobRunner = declaredField.get(t);
                    Method method = autoJobRunner.getClass().getDeclaredMethod("stop", new Class[0]);
                    method.setAccessible(true);
                    method.invoke(autoJobRunner, new Object[0]);
                }
                catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
                    logger.error("Could not stop JCo service", (Throwable)e);
                }
            });
            try {
                Field declaredField = JCoRuntimeFactory.class.getDeclaredField("runtime");
                declaredField.setAccessible(true);
                Field modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
                modifiersField.setInt(declaredField, declaredField.getModifiers() & 0xFFFFFFEF);
                declaredField.set(null, null);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                logger.error("Could not clean up JCo runtime singleton", (Throwable)e);
            }
        }
    }
}

