/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.sap.extension.internal.connection;

import com.sap.conn.jco.ext.DestinationDataEventListener;
import com.sap.conn.jco.ext.DestinationDataProvider;
import com.sap.conn.jco.ext.ServerDataEventListener;
import com.sap.conn.jco.ext.ServerDataProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SapJCoDataProvider
implements DestinationDataProvider,
ServerDataProvider {
    private static final Logger logger = LoggerFactory.getLogger(SapJCoDataProvider.class);
    private final Map<String, Properties> destinationProperties = new HashMap<String, Properties>();
    private final Map<String, Properties> serverProperties = new HashMap<String, Properties>();
    private DestinationDataEventListener destinationDataEventListener;
    private ServerDataEventListener serverDataListener;
    private static SapJCoDataProvider instance = new SapJCoDataProvider();

    private SapJCoDataProvider() {
    }

    public static synchronized SapJCoDataProvider getInstance() {
        return instance;
    }

    public Properties getDestinationProperties(String destinationName) {
        Properties properties = new Properties();
        if (this.destinationProperties.containsKey(destinationName)) {
            properties.putAll((Map<?, ?>)this.destinationProperties.get(destinationName));
        } else {
            logger.warn("No destination properties for destination: [{}]", (Object)destinationName);
        }
        return properties;
    }

    public void setDestinationDataEventListener(DestinationDataEventListener dataEventListener) {
        this.destinationDataEventListener = dataEventListener;
    }

    public boolean supportsEvents() {
        return true;
    }

    public void putDestinationProperties(String key, Properties properties) {
        boolean exists = this.destinationProperties.containsKey(key);
        this.destinationProperties.put(key, properties);
        if (exists && this.destinationDataEventListener != null && this.supportsEvents()) {
            this.destinationDataEventListener.updated(key);
            logger.debug("Destination updated notification fired for [{}]", (Object)key);
        }
        logger.info("{} destination: [{}]", (Object)(exists ? "Updated" : "Added"), (Object)key);
    }

    public Properties getServerProperties(String serverName) {
        logger.debug("About to search server [{}] in data connection: {}", (Object)serverName, this.serverProperties);
        return this.serverProperties.get(serverName);
    }

    public void setServerDataEventListener(ServerDataEventListener dataEventListener) {
        this.serverDataListener = dataEventListener;
    }

    public void addServer(String serverName, Properties config) {
        boolean exists = this.serverProperties.containsKey(serverName);
        this.serverProperties.put(serverName, config);
        if (exists && this.serverDataListener != null && this.supportsEvents()) {
            this.serverDataListener.updated(serverName);
            logger.debug("Server updated notification fired for [{}]", (Object)serverName);
        }
        logger.info("{} server: [{}]", (Object)(exists ? "Updated" : "Added"), (Object)serverName);
    }

    public void deleteServer(String serverName) {
        if (this.serverProperties.containsKey(serverName)) {
            this.serverProperties.remove(serverName);
            if (this.serverDataListener != null && this.supportsEvents()) {
                this.serverDataListener.deleted(serverName);
                logger.debug("Server deleted notification fired for [{}]", (Object)serverName);
            }
            logger.info("Deleted server: [{}]", (Object)serverName);
        } else {
            logger.warn("Server [{}] not found", (Object)serverName);
        }
    }

    public void clear() {
        this.destinationProperties.clear();
        this.destinationDataEventListener = null;
        this.serverProperties.clear();
        this.serverDataListener = null;
    }
}

