/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.sap.extension.internal.connection.provider;

import com.sap.conn.jco.util.Codecs;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Properties;
import org.mule.modules.sap.extension.internal.connection.SapConnection;
import org.mule.modules.sap.extension.internal.connection.provider.SapConnectionProvider;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.meta.ExternalLibraryType;
import org.mule.runtime.api.meta.model.display.PathModel;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.ExternalLib;
import org.mule.runtime.extension.api.annotation.ExternalLibs;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Path;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

@ExternalLibs(value={@ExternalLib(name="JCo Library", description="Java Connector for SAP Library", type=ExternalLibraryType.JAR, nameRegexpMatcher="com.sap.conn.jco.sapjco3.*.jar", requiredClassName="com.sap.conn.jco.JCo"), @ExternalLib(name="IDoc Library", description="IDocument Java Connector for SAP Library", type=ExternalLibraryType.JAR, nameRegexpMatcher="com.sap.conn.idoc.sapidoc3.*.jar", requiredClassName="com.sap.conn.idoc.jco.rt.JCoIDocDocument"), @ExternalLib(name="JCo Native Library", type=ExternalLibraryType.NATIVE, description="JCo Native Library that depends on the OS", nameRegexpMatcher="(com\\.sap\\.conn\\.jco\\.)?(lib)?sapjco3.*\\.(so|dll|jnilib)")})
@Alias(value="certificate")
public class CertificateConnectionProvider
extends SapConnectionProvider
implements CachedConnectionProvider<SapConnection> {
    @Parameter
    @Optional
    @Path(type=PathModel.Type.FILE)
    @Placement(order=1)
    @DisplayName(value="X.509 Certificate")
    @Summary(value="Path to the X.509 certificate.")
    private String path;

    @Override
    protected void addDestinationProperties(Properties properties) throws ConnectionException {
        try {
            this.addProperty(properties, "jco.client.x509cert", Codecs.Base64.encode((byte[])IOUtils.toString((InputStream)new FileInputStream(new File(this.path))).getBytes(Charset.forName("UTF-8"))));
        }
        catch (FileNotFoundException e) {
            throw new ConnectionException("Invalid path '" + this.path + "' used to retrieve the X509 certificate.", (Throwable)e);
        }
    }
}

