/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.sap.extension.internal.connection.provider;

import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import org.mule.connectors.commons.template.connection.ConnectorConnectionProvider;
import org.mule.modules.sap.extension.api.CPICTracingLevel;
import org.mule.modules.sap.extension.api.HostParameterGroup;
import org.mule.modules.sap.extension.api.TracingConfigParameterGroup;
import org.mule.modules.sap.extension.internal.connection.SapConnection;
import org.mule.modules.sap.extension.internal.connection.SapJCoDataProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public abstract class SapConnectionProvider
extends ConnectorConnectionProvider<SapConnection> {
    @ParameterGroup(name="Host")
    private HostParameterGroup hostParameterGroup;
    @Parameter
    @DisplayName(value="SAP system number")
    @Placement(order=4)
    @Summary(value="The two-digit system number (sysnr) of the SAP system.")
    @Example(value="00")
    private String systemNumber;
    @Parameter
    @DisplayName(value="SAP client ID")
    @Placement(order=5)
    @Summary(value="Three-digit client number. Preserve leading zeros if they appear in the number.")
    @Example(value="800")
    private String client;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @Placement(tab="Advanced", order=1)
    private String destinationName;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="EN")
    @DisplayName(value="Login language")
    @Placement(tab="Advanced", order=2)
    @Summary(value="Code of the language used by the connector.")
    private String language;
    @NullSafe
    @ParameterGroup(name="Tracing")
    @Placement(tab="Advanced", order=4)
    private TracingConfigParameterGroup tracingConfig;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @NullSafe
    @Placement(tab="Advanced", order=4)
    private Map<String, String> extendedProperties;

    public SapConnection connect() throws ConnectionException {
        String destinationName = Optional.ofNullable(this.destinationName).orElse(UUID.randomUUID().toString());
        Properties properties = new Properties();
        properties.putAll(this.extendedProperties);
        this.addDestinationProperties(properties);
        this.addProperty(properties, "jco.client.sysnr", this.systemNumber);
        this.addProperty(properties, "jco.client.lang", this.language);
        Optional.ofNullable(this.tracingConfig).ifPresent(tracing -> {
            this.addProperty(properties, "jco.client.trace", tracing.isTraceFromServerFlag() ? 1 : 0);
            this.addProperty(properties, "jco.client.cpic_trace", Optional.ofNullable(tracing.getCpicTracingLevel()).map(CPICTracingLevel::getLevel).orElse(null));
        });
        this.addProperty(properties, "jco.client.client", this.client);
        Optional.ofNullable(this.hostParameterGroup.getApplicationServerHost()).ifPresent(host -> this.addProperty(properties, "jco.client.ashost", host));
        Optional.ofNullable(this.hostParameterGroup.getMessageServer()).ifPresent(config -> {
            this.addProperty(properties, "jco.client.mshost", config.getHost());
            this.addProperty(properties, "jco.client.msserv", config.getPort());
            this.addProperty(properties, "jco.client.r3name", config.getSystemId());
            this.addProperty(properties, "jco.client.group", config.getGroup());
            this.addProperty(properties, "jco.client.saprouter", config.getRouter());
        });
        SapJCoDataProvider.getInstance().putDestinationProperties(destinationName, properties);
        return new SapConnection(destinationName);
    }

    protected abstract void addDestinationProperties(Properties var1) throws ConnectionException;

    protected void addProperty(Properties properties, String key, Object value) {
        Optional.ofNullable(value).ifPresent(nonNullValue -> properties.put(key, nonNullValue));
    }
}

